/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapiv3;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class ImmutableNodeSet<E extends OWLObject>
implements NodeSet<E> {
    private static final ImmutableNodeSet<?> EMPTY = ImmutableNodeSet.of(ImmutableSet.of());
    private final Set<Node<E>> nodes;

    public static <E extends OWLObject> ImmutableNodeSet<E> empty() {
        return EMPTY;
    }

    public static <E extends OWLObject> ImmutableNodeSet<E> of(Node<E> node) {
        return new ImmutableNodeSet<E>(ImmutableSet.of(node));
    }

    public static <E extends OWLObject> ImmutableNodeSet<E> of(Set<Node<E>> nodes) {
        return new ImmutableNodeSet<E>(ImmutableSet.copyOf(nodes));
    }

    private ImmutableNodeSet(ImmutableSet<Node<E>> nodes) {
        this.nodes = nodes;
    }

    public Set<Node<E>> getNodes() {
        return this.nodes;
    }

    public Set<E> getFlattened() {
        HashSet result = Sets.newHashSet();
        for (Node<E> node : this.nodes) {
            result.addAll(node.getEntities());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean containsEntity(E e) {
        for (Node<E> node : this.nodes) {
            if (!node.contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleton() {
        return this.nodes.size() == 1;
    }

    public boolean isTopSingleton() {
        return this.isSingleton() && ((Node)Iterables.get(this.nodes, (int)0)).isTopNode();
    }

    public boolean isBottomSingleton() {
        return this.isSingleton() && ((Node)Iterables.get(this.nodes, (int)0)).isBottomNode();
    }

    public Iterator<Node<E>> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        return "Nodeset" + this.nodes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeSet)) {
            return false;
        }
        NodeSet other = (NodeSet)obj;
        return this.nodes.equals(other.getNodes());
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }
}

