/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.join.JoinKey;
import org.apache.jena.sparql.engine.join.QueryIterHashJoin;
import org.apache.jena.sparql.engine.join.QueryIterHashLeftJoin_Right;
import org.apache.jena.sparql.engine.join.QueryIterNestedLoopJoin;
import org.apache.jena.sparql.engine.join.QueryIterNestedLoopLeftJoin;
import org.apache.jena.sparql.expr.ExprList;

public class Join {
    private static final boolean useNestedLoopJoin = false;
    private static final boolean useNestedLoopLeftJoin = false;

    public static QueryIterator join(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return Join.hashJoin(left, right, execCxt);
    }

    public static QueryIterator leftJoin(QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        return Join.hashLeftJoin(left, right, conditions, execCxt);
    }

    public static QueryIterator nestedLoopJoin(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return new QueryIterNestedLoopJoin(left, right, execCxt);
    }

    public static QueryIterator nestedLoopLeftJoin(QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        return new QueryIterNestedLoopLeftJoin(left, right, conditions, execCxt);
    }

    public static QueryIterator hashJoin(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return QueryIterHashJoin.create(left, right, execCxt);
    }

    public static QueryIterator hashJoin(JoinKey joinKey, QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return QueryIterHashJoin.create(joinKey, left, right, execCxt);
    }

    public static QueryIterator hashLeftJoin(QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        return QueryIterHashLeftJoin_Right.create(left, right, conditions, execCxt);
    }

    public static QueryIterator hashLeftJoin(JoinKey joinKey, QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        return QueryIterHashLeftJoin_Right.create(joinKey, left, right, conditions, execCxt);
    }

    public static QueryIterator nestedLoopJoinBasic(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        List leftRows = Iter.toList((Iterator)left);
        List output = DS.list();
        while (right.hasNext()) {
            Binding row2 = (Binding)right.next();
            for (Binding row1 : leftRows) {
                Binding r = Algebra.merge(row1, row2);
                if (r == null) continue;
                output.add(r);
            }
        }
        return new QueryIterPlainWrapper(output.iterator(), execCxt);
    }

    public static QueryIterator nestedLoopLeftJoinBasic(QueryIterator left, QueryIterator right, ExprList conditions, ExecutionContext execCxt) {
        List rightRows = Iter.toList((Iterator)right);
        List output = DS.list();
        long count = 0L;
        while (left.hasNext()) {
            Binding row1 = (Binding)left.next();
            boolean match = false;
            for (Binding row2 : rightRows) {
                Binding r = Algebra.merge(row1, row2);
                if (r == null || !Join.applyConditions(r, conditions, execCxt)) continue;
                output.add(r);
                match = true;
            }
            if (match) continue;
            output.add(row1);
        }
        return new QueryIterPlainWrapper(output.iterator(), execCxt);
    }

    private static boolean applyConditions(Binding row, ExprList conditions, ExecutionContext execCxt) {
        if (conditions == null) {
            return true;
        }
        return conditions.isSatisfied(row, execCxt);
    }

    private static QueryIterator debug(QueryIterator left, QueryIterator right, ExecutionContext execCxt, JoinOp action) {
        Table t1 = TableFactory.create(left);
        Table t2 = TableFactory.create(right);
        left = t1.iterator(execCxt);
        right = t2.iterator(execCxt);
        QueryIterator qIter = action.exec(left, right);
        Table t3 = TableFactory.create(qIter);
        System.out.println("** Left");
        System.out.println(t1);
        System.out.println("** Right");
        System.out.println(t2);
        System.out.println("** ");
        System.out.println(t3);
        return t3.iterator(execCxt);
    }

    private static /* synthetic */ QueryIterator lambda$leftJoin$1(ExprList conditions, ExecutionContext execCxt, QueryIterator _left, QueryIterator _right) {
        return Join.hashLeftJoin(_left, _right, conditions, execCxt);
    }

    private static /* synthetic */ QueryIterator lambda$join$0(ExecutionContext execCxt, QueryIterator _left, QueryIterator _right) {
        return Join.hashJoin(_left, _right, execCxt);
    }

    static interface JoinOp {
        public QueryIterator exec(QueryIterator var1, QueryIterator var2);
    }
}

