/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.http;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.http.HttpQuery;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class Service {
    public static final String base = "http://jena.hpl.hp.com/Service#";
    public static final Symbol queryDeflate = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryDeflate");
    public static final Symbol queryGzip = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryGzip");
    public static final Symbol queryAuthUser = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryAuthUser");
    public static final Symbol queryAuthPwd = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryAuthPwd");
    public static final Symbol serviceContext = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceContext");
    public static final Symbol serviceAllowed = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "serviceAllowed");
    public static final Symbol queryTimeout = SystemARQ.allocSymbol("http://jena.hpl.hp.com/Service#", "queryTimeout");

    public static QueryIterator exec(OpService op, Context context) {
        if (context != null && context.isFalse(serviceAllowed)) {
            throw new QueryExecException("SERVICE execution disabled");
        }
        if (!op.getService().isURI()) {
            throw new QueryExecException("Service URI not bound: " + op.getService());
        }
        Op opRemote = Rename.reverseVarRename(op.getSubOp(), true);
        HashMap<Var, Var> varMapping = new HashMap<Var, Var>();
        Set<Var> originalVars = OpVars.visibleVars(op);
        Set<Var> remoteVars = OpVars.visibleVars(opRemote);
        boolean requiresRemapping = false;
        for (Var v : originalVars) {
            if (v.getName().contains("/")) {
                String origName = v.getName().substring(v.getName().lastIndexOf(47) + 1);
                Var remoteVar = Var.alloc(origName);
                if (!remoteVars.contains((Object)remoteVar)) continue;
                varMapping.put(remoteVar, v);
                requiresRemapping = true;
                continue;
            }
            if (!remoteVars.contains((Object)v)) continue;
            varMapping.put(v, v);
        }
        Query query = OpAsQuery.asQuery(opRemote);
        Explain.explain("HTTP", query, context);
        String uri = op.getService().getURI();
        HttpQuery httpQuery = Service.configureQuery(uri, context, query);
        InputStream in = httpQuery.exec();
        ResultSet rs = ResultSetFactory.fromXML(in);
        QueryIterator qIter = QueryIter.materialize(new QueryIteratorResultSet(rs));
        IO.close((Closeable)in);
        if (requiresRemapping) {
            qIter = QueryIter.map(qIter, varMapping);
        }
        return qIter;
    }

    private static HttpQuery configureQuery(String uri, Context parentContext, Query query) {
        Context serviceContext;
        HttpQuery httpQuery = new HttpQuery(uri);
        Context context = new Context(parentContext);
        Map serviceContextMap = (Map)context.get(Service.serviceContext);
        if (serviceContextMap != null && (serviceContext = (Context)serviceContextMap.get(uri)) != null) {
            context.putAll(serviceContext);
        }
        httpQuery.merge(QueryEngineHTTP.getServiceParams(uri, context));
        httpQuery.addParam("query", query.toString());
        httpQuery.setAllowGZip(context.isTrueOrUndef(queryGzip));
        httpQuery.setAllowDeflate(context.isTrueOrUndef(queryDeflate));
        String user = context.getAsString(queryAuthUser);
        String pwd = context.getAsString(queryAuthPwd);
        if (user != null || pwd != null) {
            user = user == null ? "" : user;
            pwd = pwd == null ? "" : pwd;
            httpQuery.setBasicAuthentication(user, pwd.toCharArray());
        }
        Service.setAnyTimeouts(httpQuery, context);
        return httpQuery;
    }

    private static void setAnyTimeouts(HttpQuery query, Context context) {
        if (context.isDefined(queryTimeout)) {
            Object obj = context.get(queryTimeout);
            if (obj instanceof Number) {
                int x = ((Number)obj).intValue();
                query.setConnectTimeout(x);
            } else if (obj instanceof String) {
                try {
                    String str2 = obj.toString();
                    if (str2.contains(",")) {
                        String[] a = str2.split(",");
                        int x1 = Integer.parseInt(a[0]);
                        int x2 = Integer.parseInt(a[1]);
                        query.setConnectTimeout(x1);
                        query.setReadTimeout(x2);
                    }
                    int x = Integer.parseInt(str2);
                    query.setConnectTimeout(x);
                }
                catch (NumberFormatException ex) {
                    throw new QueryExecException("Can't interpret string for timeout: " + obj);
                }
            } else {
                throw new QueryExecException("Can't interpret timeout: " + obj);
            }
        }
    }
}

