/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.ext.com.google.common.cache.CacheBuilder;
import org.apache.jena.ext.com.google.common.cache.CacheStats;
import org.apache.jena.ext.com.google.common.cache.RemovalListener;

public final class CacheGuava<K, V>
implements Cache<K, V> {
    private BiConsumer<K, V> dropHandler = null;
    private org.apache.jena.ext.com.google.common.cache.Cache<K, V> cache;

    public CacheGuava(int size) {
        RemovalListener drop = notification -> {
            if (this.dropHandler != null) {
                this.dropHandler.accept(notification.getKey(), notification.getValue());
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize((long)size).removalListener(drop).recordStats().concurrencyLevel(8).build();
    }

    @Override
    public V getOrFill(K key, Callable<V> filler) {
        try {
            return (V)this.cache.get(key, filler);
        }
        catch (ExecutionException e) {
            Log.warn(CacheGuava.class, "Execution exception filling cache", (Throwable)e);
            return null;
        }
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public void put(K key, V thing) {
        if (thing == null) {
            this.cache.invalidate(key);
        } else {
            this.cache.put(key, thing);
        }
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.getIfPresent(key) != null;
    }

    @Override
    public void remove(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public Iterator<K> keys() {
        return this.cache.asMap().keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.size() == 0L;
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void setDropHandler(BiConsumer<K, V> dropHandler) {
        this.dropHandler = dropHandler;
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

