/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.tbox.impl.Unfolding;
import org.mindswap.pellet.utils.ATermUtils;

public class UnfoldingRule
extends AbstractTableauRule {
    public static final Logger log = Logger.getLogger(UnfoldingRule.class.getName());

    public UnfoldingRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.ATOM, AbstractTableauRule.BlockingType.COMPLETE);
    }

    @Override
    public void apply(Individual node) {
        if (!node.canApply(0)) {
            return;
        }
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = node.applyNext[0]; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends((ATerm)c) == null) continue;
            this.applyUnfoldingRule(node, c);
            if (this.strategy.getABox().isClosed()) {
                return;
            }
            size = types.size();
        }
        node.applyNext[0] = size;
    }

    protected void applyUnfoldingRule(Individual node, ATermAppl c) {
        DependencySet ds = node.getDepends((ATerm)c);
        if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && ds == null) {
            return;
        }
        Iterator<Unfolding> unfoldingList = this.strategy.getTBox().unfold(c);
        while (unfoldingList.hasNext()) {
            Unfolding unfolding = unfoldingList.next();
            ATermAppl unfoldingCondition = unfolding.getCondition();
            DependencySet finalDS = node.getDepends((ATerm)unfoldingCondition);
            if (finalDS == null) continue;
            Set<ATermAppl> unfoldingDS = unfolding.getExplanation();
            finalDS = finalDS.union(ds, this.strategy.getABox().doExplanation());
            finalDS = finalDS.union(unfoldingDS, this.strategy.getABox().doExplanation());
            ATermAppl unfoldedConcept = unfolding.getResult();
            if (log.isLoggable(Level.FINE) && !node.hasType((ATerm)unfoldedConcept)) {
                log.fine("UNF : " + node + ", " + ATermUtils.toString(c) + " -> " + ATermUtils.toString(unfoldedConcept) + " - " + finalDS);
            }
            this.strategy.addType(node, unfoldedConcept, finalDS);
        }
    }
}

