/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class SelfRule
extends AbstractTableauRule {
    public SelfRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.ATOM, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public final void apply(Individual node) {
        List<ATermAppl> types = node.getTypes(0);
        int size = types.size();
        for (int j = 0; j < size; ++j) {
            ATermAppl c = types.get(j);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && node.getDepends((ATerm)c) == null || !ATermUtils.isSelf(c)) continue;
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this.strategy.getABox().getRole((ATerm)pred);
            if (log.isLoggable(Level.FINE) && !node.hasRSuccessor(role, node)) {
                log.fine("SELF: " + node + " " + role + " " + node.getDepends((ATerm)c));
            }
            this.strategy.addEdge(node, role, node, node.getDepends((ATerm)c));
            if (!this.strategy.getABox().isClosed()) continue;
            return;
        }
    }
}

