/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.cache;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tableau.cache.AbstractConceptCache;
import org.mindswap.pellet.tableau.cache.CacheSafety;
import org.mindswap.pellet.tableau.cache.CacheSafetyFactory;
import org.mindswap.pellet.tableau.cache.CachedNode;
import org.mindswap.pellet.tableau.cache.ConceptCache;
import org.mindswap.pellet.utils.ATermUtils;

public class ConceptCacheLRU
extends AbstractConceptCache
implements ConceptCache {
    private Map<ATermAppl, CachedNode> primitive;
    private LinkedHashMap<ATermAppl, CachedNode> nonPrimitive;
    private CacheSafety cacheSafety;

    public ConceptCacheLRU(KnowledgeBase kb) {
        this(kb, Integer.MAX_VALUE);
    }

    public ConceptCacheLRU(KnowledgeBase kb, int maxSize) {
        super(maxSize);
        this.cacheSafety = CacheSafetyFactory.createCacheSafety(kb.getExpressivity());
        this.primitive = new HashMap<ATermAppl, CachedNode>();
        this.nonPrimitive = new LinkedHashMap<ATermAppl, CachedNode>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ATermAppl, CachedNode> eldest) {
                return ConceptCacheLRU.this.nonPrimitive.size() > ConceptCacheLRU.this.getMaxSize();
            }
        };
    }

    @Override
    public CacheSafety getSafety() {
        return this.cacheSafety;
    }

    @Override
    public void clear() {
        this.primitive.clear();
        this.nonPrimitive.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.primitive.containsKey(key) || this.nonPrimitive.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.primitive.containsValue(value) || this.nonPrimitive.containsValue(value);
    }

    @Override
    public Set<Map.Entry<ATermAppl, CachedNode>> entrySet() {
        HashSet<Map.Entry<ATermAppl, CachedNode>> returnSet = new HashSet<Map.Entry<ATermAppl, CachedNode>>(this.primitive.entrySet());
        returnSet.addAll(this.nonPrimitive.entrySet());
        return returnSet;
    }

    @Override
    public CachedNode get(Object key) {
        if (this.primitive.containsKey(key)) {
            return this.primitive.get(key);
        }
        return this.nonPrimitive.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.primitive.isEmpty() && this.nonPrimitive.isEmpty();
    }

    @Override
    public Set<ATermAppl> keySet() {
        HashSet<ATermAppl> keys = new HashSet<ATermAppl>(this.primitive.keySet());
        keys.addAll(this.nonPrimitive.keySet());
        return keys;
    }

    @Override
    public CachedNode put(ATermAppl key, CachedNode value) {
        if (ATermUtils.isPrimitiveOrNegated(key)) {
            CachedNode prev = this.primitive.put(key, value);
            if (this.isFull()) {
                this.nonPrimitive.entrySet();
            }
            return prev;
        }
        return this.nonPrimitive.put(key, value);
    }

    @Override
    public void putAll(Map<? extends ATermAppl, ? extends CachedNode> t) {
        for (Map.Entry<? extends ATermAppl, ? extends CachedNode> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public CachedNode remove(Object key) {
        if (this.primitive.containsKey(key)) {
            return this.primitive.remove(key);
        }
        return (CachedNode)this.nonPrimitive.remove(key);
    }

    @Override
    public int size() {
        return this.primitive.size() + this.nonPrimitive.size();
    }

    @Override
    public Collection<CachedNode> values() {
        HashSet<CachedNode> valueSet = new HashSet<CachedNode>(this.primitive.values());
        valueSet.addAll(this.nonPrimitive.values());
        return valueSet;
    }

    public String toString() {
        return "[Cache size: " + this.primitive.size() + "," + this.nonPrimitive.size() + "]";
    }
}

