/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class DeltaSet<T>
extends AbstractSet<T> {
    private final Set<T> base;
    private final Set<T> additions = Sets.newHashSet();
    private final Set<T> removals = Sets.newHashSet();

    public DeltaSet(Set<T> base) {
        this.base = Objects.requireNonNull(base);
    }

    public void reset() {
        this.additions.clear();
        this.removals.clear();
    }

    public Set<T> getAdditions() {
        return this.additions;
    }

    public Set<T> getRemovals() {
        return this.removals;
    }

    @Override
    public void clear() {
        this.additions.clear();
        this.removals.addAll(this.base);
    }

    @Override
    public boolean contains(Object o) {
        return this.additions.contains(o) || !this.removals.contains(o) && this.base.contains(o);
    }

    @Override
    public boolean add(T e) {
        return this.removals.remove(e) || !this.base.contains(e) && this.additions.add(e);
    }

    @Override
    public boolean remove(Object e) {
        return this.additions.remove(e) || this.base.contains(e) && this.removals.add(e);
    }

    @Override
    public Iterator<T> iterator() {
        Object result = this.base.iterator();
        if (!this.removals.isEmpty()) {
            result = Iterators.filter(result, (Predicate)Predicates.not((Predicate)Predicates.in(this.removals)));
        }
        if (!this.additions.isEmpty()) {
            result = Iterators.concat((Iterator)result, this.additions.iterator());
        }
        return result;
    }

    @Override
    public int size() {
        return this.base.size() + this.additions.size() - this.removals.size();
    }
}

