/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.Trigger;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

class ConceptInfo {
    public static final Logger logger = Logger.getLogger(ConceptInfo.class.getName());
    private final ATermAppl concept;
    private final Set<Trigger> triggers;
    private final MultiValueMap<ATermAppl, ConceptInfo> successors;
    private final MultiValueMap<ATermAppl, ConceptInfo> predecessors;
    private final Set<ConceptInfo> superClasses;

    public ConceptInfo(ATermAppl c, boolean storeSuccessors, boolean noTriggers) {
        this.concept = c;
        this.superClasses = CollectionUtils.makeSet();
        this.successors = storeSuccessors ? new MultiValueMap() : null;
        this.predecessors = new MultiValueMap();
        this.triggers = noTriggers ? null : new HashSet();
    }

    public boolean addSuccessor(ATermAppl p, ConceptInfo ci) {
        if (ci.predecessors.add(p, this)) {
            if (this.successors != null) {
                this.successors.add(p, ci);
            }
            return true;
        }
        return false;
    }

    public boolean addSuperClass(ConceptInfo sup) {
        return this.superClasses.add(sup);
    }

    public boolean addTrigger(Trigger trigger) {
        return this.triggers.add(trigger);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConceptInfo && ((ConceptInfo)obj).concept == this.concept;
    }

    public ATermAppl getConcept() {
        return this.concept;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getSuccessors() {
        return this.successors;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getPredecessors() {
        return this.predecessors;
    }

    public Set<ConceptInfo> getSuperClasses() {
        return this.superClasses;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public boolean hasSuccessor(ATermAppl p, ConceptInfo ci) {
        return ci.predecessors.contains(p, this);
    }

    public int hashCode() {
        return this.concept.hashCode();
    }

    public boolean hasSuperClass(ConceptInfo ci) {
        return this.superClasses.contains(ci);
    }

    public String toString() {
        return ATermUtils.toString(this.concept);
    }
}

