/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.profiles.OWLOntologyProfileWalker;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.Profiles;
import org.semanticweb.owlapi.profiles.violations.LexicalNotInLexicalSpace;
import org.semanticweb.owlapi.profiles.violations.OntologyIRINotAbsolute;
import org.semanticweb.owlapi.profiles.violations.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapi.profiles.violations.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapi.profiles.violations.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapi.profiles.violations.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2Profile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2";
    }

    @Override
    @Nonnull
    public IRI getIRI() {
        return Profiles.OWL2_FULL.getIRI();
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWLOntologyProfileWalker walker = new OWLOntologyProfileWalker(ontology.getImportsClosure());
        OWL2ProfileObjectWalker visitor = new OWL2ProfileObjectWalker(walker, ontology.getOWLOntologyManager());
        walker.walkStructure(visitor);
        Set<OWLProfileViolation> pv = visitor.getProfileViolations();
        return new OWLProfileReport(this, pv);
    }

    private static class OWL2ProfileObjectWalker
    extends OWLOntologyWalkerVisitor {
        @Nonnull
        private final OWLOntologyManager man;
        @Nonnull
        private final Set<OWLProfileViolation> profileViolations = new HashSet<OWLProfileViolation>();

        OWL2ProfileObjectWalker(@Nonnull OWLOntologyWalker walker, @Nonnull OWLOntologyManager man) {
            super(walker);
            this.man = man;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        @Override
        public void visit(OWLOntology ontology) {
            OWLOntologyID id = ontology.getOntologyID();
            if (!id.isAnonymous()) {
                Optional<IRI> versionIRI;
                IRI ontologyIRI = (IRI)id.getOntologyIRI().get();
                if (!ontologyIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyIRINotAbsolute(ontology));
                }
                if ((versionIRI = id.getVersionIRI()).isPresent() && !((IRI)versionIRI.get()).isAbsolute()) {
                    this.profileViolations.add(new OntologyVersionIRINotAbsolute(ontology));
                }
            }
        }

        @Override
        public void visit(IRI iri) {
            if (!iri.isAbsolute()) {
                this.profileViolations.add(new UseOfNonAbsoluteIRI(this.getCurrentOntology(), this.getCurrentAxiom(), iri));
            }
        }

        @Override
        public void visit(OWLLiteral node) {
            if (node.getDatatype().isBuiltIn() && !node.getDatatype().getBuiltInDatatype().isInLexicalSpace(node.getLiteral())) {
                this.profileViolations.add(new LexicalNotInLexicalSpace(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
        }

        @Override
        public void visit(OWLDatatypeRestriction node) {
            for (OWLOntology ont : this.man.getImportsClosure(this.getCurrentOntology())) {
                for (OWLDatatypeDefinitionAxiom ax : ont.getAxioms(AxiomType.DATATYPE_DEFINITION)) {
                    if (!node.getDatatype().equals(ax.getDatatype())) continue;
                    this.profileViolations.add(new UseOfDefinedDatatypeInDatatypeRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
            }
            for (OWLFacetRestriction r : node.getFacetRestrictions()) {
                OWL2Datatype dt = node.getDatatype().getBuiltInDatatype();
                if (dt.getFacets().contains(r.getFacet())) continue;
                this.profileViolations.add(new UseOfIllegalFacetRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node, r.getFacet()));
            }
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            if (!this.getCurrentOntology().isDeclared(axiom.getDatatype(), Imports.INCLUDED)) {
                this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), (OWLAxiom)axiom, axiom.getDatatype()));
            }
        }
    }
}

