/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss1.parser;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.KRSSDocumentFormat;
import org.semanticweb.owlapi.formats.KRSSDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.krss1.parser.KRSSOWLParserException;
import org.semanticweb.owlapi.krss1.parser.KRSSParser;
import org.semanticweb.owlapi.krss1.parser.ParseException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class KRSSOWLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Override
    @Nonnull
    public String getName() {
        return "KRSSOWLParser";
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new KRSSDocumentFormatFactory();
    }

    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        try {
            KRSSDocumentFormat format = new KRSSDocumentFormat();
            KRSSParser parser = documentSource.isReaderAvailable() ? new KRSSParser(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new KRSSParser(documentSource.getInputStream()) : new KRSSParser(this.getInputStream(documentSource.getDocumentIRI(), configuration)));
            parser.setOntology(ontology, ontology.getOWLOntologyManager().getOWLDataFactory());
            parser.parse();
            return format;
        }
        catch (ParseException e) {
            throw new KRSSOWLParserException(e);
        }
    }
}

