/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.tukaani.xz.XZInputStream;

public class XZFileDocumentSource
extends OWLOntologyDocumentSourceBase {
    @Nonnull
    private final IRI documentIRI;
    @Nonnull
    private final File file;

    public XZFileDocumentSource(@Nonnull File is) {
        this(is, XZFileDocumentSource.getNextDocumentIRI("file:ontology"), null, null);
    }

    public XZFileDocumentSource(@Nonnull File stream, @Nonnull IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(format, mime);
        this.documentIRI = documentIRI;
        this.file = stream;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return this.file.exists();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        try {
            return XZFileDocumentSource.wrap((InputStream)new XZInputStream((InputStream)new BufferedInputStream(new FileInputStream(this.file))));
        }
        catch (FileNotFoundException e) {
            throw new OWLOntologyInputSourceException("File not found - check that the file is available before calling this method.", e);
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return this.file.exists();
    }
}

