/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.reachability;

import com.clarkparsia.reachability.Node;

public class AndNode
extends Node {
    private int activatedInputs;
    private int id;

    public AndNode(int id) {
        this.id = id;
        this.activatedInputs = 0;
    }

    @Override
    public boolean inputActivated() {
        return ++this.activatedInputs == this.inputs.size();
    }

    @Override
    public boolean isActive() {
        return this.activatedInputs == this.inputs.size();
    }

    @Override
    public boolean isRedundant() {
        return this.outputs.isEmpty() || this.inputs.size() == 1 || this.outputs.size() == 1 && this.outputs.iterator().next() instanceof AndNode;
    }

    @Override
    public void reset() {
        this.activatedInputs = 0;
    }

    public String toString() {
        return "And(" + this.id + ")[" + this.activatedInputs + "," + this.inputs.size() + "]";
    }
}

