/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import aterm.ATermAppl;
import com.clarkparsia.modularity.EntailmentChecker;
import com.clarkparsia.modularity.IncrementalReasonerConfiguration;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.ModuleExtractorFactory;
import com.clarkparsia.modularity.OntologyDiff;
import com.clarkparsia.modularity.io.TaxonomyPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import com.clarkparsia.owlapiv3.AbstractOWLListeningReasoner;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.exceptions.PelletRuntimeException;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.TimerInterruptedException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.taxonomy.printer.TreeTaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.PartialOrderBuilder;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.mindswap.pellet.utils.PartialOrderRelation;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.util.Version;

public class IncrementalReasoner
extends AbstractOWLListeningReasoner {
    public static final Logger log = Logger.getLogger(IncrementalReasoner.class.getName());
    private final PelletReasoner reasoner;
    private final ModuleExtractor extractor;
    private Taxonomy<OWLClass> taxonomy = null;
    private boolean multiThreaded = true;
    public final Timers timers;
    private final Random RND = new Random();
    private boolean classified = false;
    private boolean realized = false;
    private static final ATermAppl OWL_THING = ATermUtils.makeTermAppl((String)"http://www.w3.org/2002/07/owl#Thing");
    private static final ATermAppl OWL_NOTHING = ATermUtils.makeTermAppl((String)"http://www.w3.org/2002/07/owl#Nothing");

    public static IncrementalReasonerConfiguration config() {
        return new IncrementalReasonerConfiguration();
    }

    public IncrementalReasoner(OWLOntology ontology, IncrementalReasonerConfiguration config) {
        this.extractor = config.getModuleExtractor() != null ? config.getModuleExtractor() : ModuleExtractorFactory.createModuleExtractor();
        this.timers = this.extractor.getTimers();
        this.multiThreaded = config.isMultiThreaded();
        if (config.getFile() == null) {
            this.reasoner = config.getReasoner() != null ? config.getReasoner() : config.createReasoner(ontology);
            ontology = this.reasoner.getRootOntology();
            for (OWLOntology ont : ontology.getImportsClosure()) {
                for (OWLAxiom axiom : ont.getAxioms()) {
                    this.extractor.addAxiom(axiom);
                }
            }
        } else {
            Properties properties = new Properties();
            try {
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(config.getFile()));
                Iterator<OWLAxiom> iterator = null;
                try {
                    this.extractor.load(zipInputStream);
                    ZipEntry currentEntry = zipInputStream.getNextEntry();
                    if (!"Taxonomy".equals(currentEntry.getName())) {
                        throw new IOException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", currentEntry.getName(), "Taxonomy"));
                    }
                    this.taxonomy = TaxonomyPersistence.load(zipInputStream);
                    currentEntry = zipInputStream.getNextEntry();
                    if (currentEntry != null && "Properties".equals(currentEntry.getName())) {
                        properties.load(zipInputStream);
                    }
                }
                catch (Throwable currentEntry) {
                    iterator = currentEntry;
                    throw currentEntry;
                }
                finally {
                    if (zipInputStream != null) {
                        if (iterator != null) {
                            try {
                                zipInputStream.close();
                            }
                            catch (Throwable currentEntry) {
                                ((Throwable)((Object)iterator)).addSuppressed(currentEntry);
                            }
                        } else {
                            zipInputStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalConfigurationException("Specified file is invalid", (Throwable)e, (OWLReasonerConfiguration)config);
            }
            this.realized = Boolean.valueOf(properties.getProperty("realized", "false"));
            this.classified = true;
            if (ontology == null) {
                String ontologyIRI = properties.getProperty("ontologyIRI");
                try {
                    ontology = config.getManager().createOntology(Strings.isNullOrEmpty((String)ontologyIRI) ? null : IRI.create((String)ontologyIRI));
                }
                catch (OWLOntologyCreationException e) {
                    e.printStackTrace();
                }
                OntologyUtils.addAxioms((OWLOntology)ontology, this.extractor.getAxioms());
            }
            this.reasoner = config.getReasoner() != null ? config.getReasoner() : config.createReasoner(ontology);
            ontology = this.reasoner.getRootOntology();
            OntologyDiff diff = OntologyDiff.diffAxiomsWithOntologies(this.extractor.getAxioms(), Collections.singleton(ontology));
            for (OWLAxiom addition : diff.getAdditions()) {
                this.extractor.addAxiom(addition);
            }
            for (OWLAxiom deletion : diff.getDeletions()) {
                this.extractor.deleteAxiom(deletion);
            }
        }
        this.setListenChanges(config.isListenChanges());
    }

    private IncrementalReasoner(IncrementalReasoner that) {
        this.extractor = that.extractor.copy();
        this.timers = that.timers;
        this.multiThreaded = that.multiThreaded;
        this.classified = that.classified;
        if (this.classified) {
            this.taxonomy = IncrementalReasoner.buildClassHierarchy((OWLReasoner)that);
        }
        this.realized = false;
        try {
            OWLOntology ont = that.getRootOntology();
            OWLOntologyManager manager = ont.getOWLOntologyManager();
            OWLOntology copyOnt = manager.createOntology();
            manager.addAxioms(copyOnt, ont.getAxioms());
            this.reasoner = PelletReasonerFactory.getInstance().createReasoner(copyOnt);
            this.setListenChanges(true);
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public IncrementalReasoner copy() {
        return new IncrementalReasoner(this);
    }

    public OWLOntologyManager getManager() {
        return this.reasoner.getManager();
    }

    public static Taxonomy<OWLClass> buildClassHierarchy(OWLReasoner reasoner) {
        Taxonomy taxonomy = new Taxonomy(null, (Object)OWL.Thing, (Object)OWL.Nothing);
        Set things = reasoner.getEquivalentClasses((OWLClassExpression)OWL.Thing).getEntities();
        things.remove(OWL.Thing);
        if (!things.isEmpty()) {
            taxonomy.addEquivalents((Object)OWL.Thing, (Collection)things);
        }
        Set nothings = reasoner.getEquivalentClasses((OWLClassExpression)OWL.Nothing).getEntities();
        nothings.remove(OWL.Nothing);
        if (!nothings.isEmpty()) {
            taxonomy.addEquivalents((Object)OWL.Nothing, (Collection)nothings);
        }
        for (Node subEq : reasoner.getSubClasses((OWLClassExpression)OWL.Thing, true)) {
            IncrementalReasoner.recursiveBuild((Taxonomy<OWLClass>)taxonomy, (Node<OWLClass>)subEq, reasoner);
        }
        return taxonomy;
    }

    private static void recursiveBuild(Taxonomy<OWLClass> taxonomy, Node<OWLClass> eqClasses, OWLReasoner reasoner) {
        assert (!eqClasses.getEntities().isEmpty()) : "Equivalents empty as passed";
        OWLClass cls = (OWLClass)eqClasses.iterator().next();
        if (taxonomy.contains((Object)cls)) {
            return;
        }
        Set emptySet = Collections.emptySet();
        taxonomy.addNode((Collection)eqClasses.getEntities(), emptySet, emptySet, false);
        for (Node subEq : reasoner.getSubClasses((OWLClassExpression)cls, true)) {
            IncrementalReasoner.recursiveBuild(taxonomy, (Node<OWLClass>)subEq, reasoner);
            taxonomy.addSuper(subEq.iterator().next(), (Object)cls);
        }
    }

    public void classify() {
        if (this.isClassified()) {
            if (this.extractor.isChanged()) {
                this.extractor.applyChanges(this.taxonomy);
            }
            return;
        }
        this.classified = true;
        if (this.extractor.canUpdate()) {
            this.incrementalClassify();
        } else {
            this.regularClassify();
        }
        this.resetRealization();
    }

    public void dispose() {
        this.setListenChanges(false);
        this.reasoner.dispose();
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression clsC) {
        if (clsC.isAnonymous()) {
            throw new IllegalArgumentException("This reasoner only supports named classes");
        }
        this.classify();
        return NodeFactory.getOWLClassNode((Set)this.taxonomy.getAllEquivalents((Object)((OWLClass)clsC)));
    }

    public ModuleExtractor getModuleExtractor() {
        return this.extractor;
    }

    public PelletReasoner getReasoner() {
        return this.reasoner;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression clsC, boolean direct) {
        if (clsC.isAnonymous()) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.classify();
        HashSet<DefaultNode> values = new HashSet<DefaultNode>();
        for (Set val : this.taxonomy.getSubs((Object)((OWLClass)clsC), direct)) {
            values.add(NodeFactory.getOWLClassNode((Set)val));
        }
        return new OWLClassNodeSet(values);
    }

    private void incClassifyAllModStrategy() {
        Set<OWLEntity> effects = this.extractor.applyChanges(this.taxonomy);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Module entities " + effects);
        }
        OWLOntology owlModule = this.extractor.getModuleFromSignature(effects);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Module axioms " + owlModule.getLogicalAxioms());
        }
        PelletReasoner moduleReasoner = PelletReasonerFactory.getInstance().createReasoner(owlModule);
        moduleReasoner.getKB().classify();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Classified module:");
            new ClassTreePrinter().print(moduleReasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
        }
        Taxonomy<OWLClass> moduleTaxonomy = IncrementalReasoner.buildClassHierarchy((OWLReasoner)moduleReasoner);
        HashSet<OWLClass> affectedCls = new HashSet<OWLClass>();
        for (OWLEntity entity : effects) {
            if (!(entity instanceof OWLClass)) continue;
            affectedCls.add((OWLClass)entity);
        }
        this.taxonomy = this.updateClassHierarchy(this.taxonomy, moduleTaxonomy, affectedCls);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Updated taxonomy:");
            new TreeTaxonomyPrinter().print(this.taxonomy, new PrintWriter(System.err));
        }
        OntologyUtils.getOWLOntologyManager().removeOntology(owlModule);
    }

    private void incrementalClassify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Incremental classification starting");
        }
        Timer timer = this.timers.startTimer("incrementalClassify");
        this.incClassifyAllModStrategy();
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Incremental classification done");
        }
    }

    public boolean isClassified() {
        return this.classified && (!this.extractor.isChanged() || !this.extractor.isClassificationNeeded(this.reasoner.getKB().getExpressivity()));
    }

    public boolean isRealized() {
        return this.isClassified() && this.realized;
    }

    public boolean isSatisfiable(OWLClassExpression description) {
        if (description.isAnonymous() || !this.isClassified()) {
            return this.reasoner.isSatisfiable(description);
        }
        return !this.getUnsatisfiableClasses().contains((OWLObject)((OWLClass)description));
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        OWLOntology ont = this.getRootOntology();
        if (ont == null || ont.getOWLOntologyManager() == null || !ont.getOWLOntologyManager().contains(ont.getOntologyID())) {
            return;
        }
        Set ontologies = ont.getImportsClosure();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !ontologies.contains(oWLOntologyChange.getOntology())) continue;
            this.resetRealization();
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange instanceof AddAxiom) {
                this.extractor.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange instanceof RemoveAxiom) {
                this.extractor.deleteAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }

    private void regularClassify() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Regular classification starting");
        }
        Thread classification = new Thread("classification"){

            @Override
            public void run() {
                Timer timer = IncrementalReasoner.this.timers.startTimer("reasonerClassify");
                IncrementalReasoner.this.reasoner.flush();
                IncrementalReasoner.this.reasoner.getKB().classify();
                timer.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Regular taxonomy:");
                    new TreeTaxonomyPrinter().print(IncrementalReasoner.this.reasoner.getKB().getTaxonomy(), new PrintWriter(System.err));
                }
                timer = IncrementalReasoner.this.timers.startTimer("buildClassHierarchy");
                IncrementalReasoner.this.taxonomy = IncrementalReasoner.buildClassHierarchy((OWLReasoner)IncrementalReasoner.this.reasoner);
                timer.stop();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Copied taxonomy:");
                    new TreeTaxonomyPrinter().print(IncrementalReasoner.this.taxonomy, new PrintWriter(System.err));
                }
            }
        };
        Thread partitioning = new Thread("partitioning"){

            @Override
            public void run() {
                IncrementalReasoner.this.extractor.extractModules();
            }
        };
        try {
            Timer timer = this.timers.startTimer("regularClassify");
            if (this.multiThreaded) {
                classification.start();
                partitioning.start();
                classification.join();
                partitioning.join();
            } else {
                classification.run();
                partitioning.run();
            }
            timer.stop();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Regular classification done");
        }
    }

    private Taxonomy<OWLClass> updateClassHierarchy(Taxonomy<OWLClass> taxonomy, Taxonomy<OWLClass> moduleTaxonomy, Set<OWLClass> affected) {
        HashSet inTaxonomy = new HashSet(moduleTaxonomy.getClasses());
        inTaxonomy.remove(OWL.Thing);
        inTaxonomy.remove(OWL.Nothing);
        assert (affected.containsAll(inTaxonomy)) : "Unaffected nodes in changed taxonomy";
        HashSet<OWLClass> removed = new HashSet<OWLClass>(affected);
        removed.removeAll(moduleTaxonomy.getClasses());
        List sorted = taxonomy.topologocialSort(false);
        Set emptySet = Collections.emptySet();
        for (OWLClass cls : sorted) {
            if (removed.contains(cls) || moduleTaxonomy.contains((Object)cls)) continue;
            moduleTaxonomy.addNode((Collection)taxonomy.getAllEquivalents((Object)cls), emptySet, emptySet, false);
            Set supers = taxonomy.getFlattenedSupers((Object)cls, true);
            supers.removeAll(removed);
            moduleTaxonomy.addSupers((Object)cls, (Collection)supers);
        }
        ArrayList<OWLClass> nothings = new ArrayList<OWLClass>();
        for (OWLClass cls : taxonomy.getEquivalents((Object)OWL.Nothing)) {
            if (removed.contains(cls) || moduleTaxonomy.contains((Object)cls)) continue;
            nothings.add(cls);
        }
        if (!nothings.isEmpty()) {
            moduleTaxonomy.addEquivalents((Object)OWL.Nothing, nothings);
        }
        return moduleTaxonomy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));){
            this.extractor.save(zipOutputStream);
            ZipEntry taxonomyEntry = new ZipEntry("Taxonomy");
            zipOutputStream.putNextEntry(taxonomyEntry);
            TaxonomyPersistence.save(this.taxonomy, new UncloseableOutputStream(zipOutputStream));
            ZipEntry propertiesEntry = new ZipEntry("Properties");
            zipOutputStream.putNextEntry(propertiesEntry);
            Properties properties = new Properties();
            properties.setProperty("realized", String.valueOf(this.realized));
            Optional ontIRI = this.getRootOntology().getOntologyID().getOntologyIRI();
            if (ontIRI.isPresent()) {
                properties.setProperty("ontologyIRI", ((IRI)ontIRI.get()).toString());
            }
            properties.store(zipOutputStream, "Properties of the IncrementalClassifier");
        }
    }

    public void flush() {
        this.reasoner.flush();
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)OWL.Nothing);
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        return this.getEquivalentDataProperties(OWL.bottomDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)OWL.bottomObjectProperty);
    }

    public BufferingMode getBufferingMode() {
        return BufferingMode.NON_BUFFERING;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDataPropertyDomains(pe, direct);
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDataPropertyValues(ind, pe);
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDifferentIndividuals(ind);
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce) {
        DisjointClassComparator disjointClassComparator = new DisjointClassComparator(this.taxonomy, ce);
        if (!this.taxonomy.contains((Object)disjointClassComparator.getComplementRepresentation())) {
            this.reasoner.flush();
            PartialOrderBuilder orderBuilder = new PartialOrderBuilder(this.taxonomy, (PartialOrderComparator)disjointClassComparator);
            orderBuilder.add((Object)disjointClassComparator.getComplementRepresentation(), true);
        }
        OWLClassNodeSet result = new OWLClassNodeSet();
        for (Set equivSet : this.taxonomy.getSubs((Object)disjointClassComparator.getComplementRepresentation(), false)) {
            result.addSameEntities(equivSet);
        }
        return result;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDisjointDataProperties(pe);
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getDisjointObjectProperties(pe);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getEquivalentDataProperties(pe);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getEquivalentObjectProperties(pe);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.reasoner.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.reasoner.getIndividualNodeSetPolicy();
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<OWLNamedIndividual> individuals) {
        HashSet<Node> instances = new HashSet<Node>();
        HashSet seen = new HashSet();
        for (OWLNamedIndividual ind : individuals) {
            if (seen.contains(ind)) continue;
            Node equiv = this.reasoner.getSameIndividuals(ind);
            instances.add(equiv);
            seen.addAll(equiv.getEntities());
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<OWLNamedIndividual> individuals) {
        HashSet<OWLNamedIndividualNode> instances = new HashSet<OWLNamedIndividualNode>();
        for (OWLNamedIndividual ind : individuals) {
            for (OWLNamedIndividual equiv : this.reasoner.getSameIndividuals(ind)) {
                instances.add(new OWLNamedIndividualNode(equiv));
            }
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<OWLNamedIndividual> individuals) {
        if (IndividualNodeSetPolicy.BY_NAME.equals((Object)this.getIndividualNodeSetPolicy())) {
            return this.getIndividualNodeSetByName(individuals);
        }
        if (IndividualNodeSetPolicy.BY_SAME_AS.equals((Object)this.getIndividualNodeSetPolicy())) {
            return this.getIndividualNodeSetBySameAs(individuals);
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this.getIndividualNodeSetPolicy()));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (ce.isAnonymous() && direct) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.reasoner.flush();
        if (!this.isRealized() && !direct) {
            return this.reasoner.getInstances(ce, direct);
        }
        this.realize();
        Set individuals = direct ? TaxonomyUtils.getDirectInstances(this.taxonomy, (Object)((OWLClass)ce)) : TaxonomyUtils.getAllInstances(this.taxonomy, (Object)((OWLClass)ce));
        return this.getIndividualNodeSet(individuals);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getInverseObjectProperties(pe);
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getObjectPropertyDomains(pe, direct);
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getObjectPropertyRanges(pe, direct);
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getObjectPropertyValues(ind, pe);
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return Collections.emptyList();
    }

    public String getReasonerName() {
        return "Pellet (Incremental)";
    }

    public Version getReasonerVersion() {
        return this.reasoner.getReasonerVersion();
    }

    public OWLOntology getRootOntology() {
        return this.reasoner.getRootOntology();
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSameIndividuals(ind);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSubDataProperties(pe, direct);
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSubObjectProperties(pe, direct);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (ce.isAnonymous()) {
            throw new UnsupportedOperationException("This reasoner only supports named classes");
        }
        this.classify();
        HashSet<DefaultNode> values = new HashSet<DefaultNode>();
        for (Set val : this.taxonomy.getSupers((Object)((OWLClass)ce), direct)) {
            values.add(NodeFactory.getOWLClassNode((Set)val));
        }
        return new OWLClassNodeSet(values);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSuperDataProperties(pe, direct);
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.getSuperObjectProperties(pe, direct);
    }

    public long getTimeOut() {
        return this.reasoner.getTimeOut();
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)OWL.Thing);
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        return this.getEquivalentDataProperties(OWL.topDataProperty);
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)OWL.topObjectProperty);
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        this.realize();
        OWLClassNodeSet types = new OWLClassNodeSet();
        for (Set t : TaxonomyUtils.getTypes(this.taxonomy, (Object)ind, (boolean)direct)) {
            types.addNode((Node)new OWLClassNode(t));
        }
        return types;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.classify();
        return this.getBottomClassNode();
    }

    public void interrupt() {
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this.reasoner.flush();
        return this.reasoner.isConsistent();
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axiom);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axioms);
        }
        catch (PelletRuntimeException e) {
            throw this.convert(e);
        }
    }

    private PelletRuntimeException convert(PelletRuntimeException e) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (e instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (e instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)e);
        }
        if (e instanceof org.mindswap.pellet.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
        if (e instanceof UndefinedEntityException) {
            Set unknown = Collections.emptySet();
            throw new FreshEntitiesException(unknown);
        }
        return e;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return this.getReasoner().isEntailmentCheckingSupported(axiomType);
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.classify();
    }

    public Taxonomy<OWLClass> getTaxonomy() {
        return this.taxonomy;
    }

    private void resetRealization() {
        if (this.taxonomy != null) {
            for (TaxonomyNode node : this.taxonomy.getNodes()) {
                node.removeDatum(TaxonomyUtils.INSTANCES_KEY);
            }
        }
        this.realized = false;
    }

    private void realize() {
        if (this.isRealized()) {
            return;
        }
        Set allIndividuals = this.reasoner.getKB().getIndividuals();
        HashSet<OWLClass> visitedClasses = new HashSet<OWLClass>();
        if (!allIndividuals.isEmpty()) {
            this.realizeByConcept(ATermUtils.TOP, allIndividuals, this.reasoner.getManager().getOWLDataFactory(), visitedClasses);
        }
        this.realized = true;
    }

    private Set<ATermAppl> realizeByConcept(ATermAppl c, Collection<ATermAppl> individuals, OWLDataFactory factory, Set<OWLClass> visitedClasses) {
        OWLClass owlClass;
        if (c.equals(ATermUtils.BOTTOM)) {
            return SetUtils.emptySet();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Realizing concept " + c);
        }
        if (visitedClasses.contains(owlClass = this.termToOWLClass(c, factory))) {
            return TaxonomyUtils.getAllInstances(this.taxonomy, (Object)owlClass);
        }
        HashSet<ATermAppl> instances = new HashSet<ATermAppl>(this.reasoner.getKB().retrieve(c, individuals));
        HashSet<ATermAppl> mostSpecificInstances = new HashSet<ATermAppl>(instances);
        if (!instances.isEmpty()) {
            TaxonomyNode node = this.taxonomy.getNode((Object)owlClass);
            if (node == null) {
                System.out.println(" no node for " + c);
            }
            for (TaxonomyNode sub : node.getSubs()) {
                OWLClass d = (OWLClass)sub.getName();
                Set<ATermAppl> subInstances = this.realizeByConcept(this.owlClassToTerm(d), instances, factory, visitedClasses);
                if (subInstances == null) {
                    return null;
                }
                mostSpecificInstances.removeAll(subInstances);
            }
            if (!mostSpecificInstances.isEmpty()) {
                node.putDatum(TaxonomyUtils.INSTANCES_KEY, this.toOWLNamedIndividuals(mostSpecificInstances, factory));
            }
        }
        return instances;
    }

    private Set<OWLNamedIndividual> toOWLNamedIndividuals(Set<ATermAppl> terms, OWLDataFactory factory) {
        HashSet<OWLNamedIndividual> result = new HashSet<OWLNamedIndividual>();
        for (ATermAppl ind : terms) {
            OWLNamedIndividual owlInd = this.termToOWLNamedIndividual(ind, factory);
            if (owlInd == null) continue;
            result.add(owlInd);
        }
        return result;
    }

    private OWLClass termToOWLClass(ATermAppl c, OWLDataFactory factory) {
        if (c.equals(ATermUtils.TOP)) {
            return factory.getOWLThing();
        }
        if (c.equals(OWL_THING)) {
            return factory.getOWLThing();
        }
        if (c.equals(OWL_NOTHING)) {
            return factory.getOWLNothing();
        }
        if (!ATermUtils.isBnode((ATermAppl)c)) {
            return factory.getOWLClass(IRI.create((String)c.getName()));
        }
        return null;
    }

    private OWLNamedIndividual termToOWLNamedIndividual(ATermAppl c, OWLDataFactory factory) {
        if (!ATermUtils.isBnode((ATermAppl)c)) {
            return factory.getOWLNamedIndividual(IRI.create((String)c.getName()));
        }
        return null;
    }

    private ATermAppl owlClassToTerm(OWLClass c) {
        if (c.isOWLThing()) {
            return ATermUtils.TOP;
        }
        if (c.isOWLNothing()) {
            return ATermUtils.BOTTOM;
        }
        return ATermUtils.makeTermAppl((String)c.getIRI().toString());
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return this.reasoner.getPrecomputableInferenceTypes();
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        switch (inferenceType) {
            case CLASS_HIERARCHY: {
                return this.isClassified();
            }
            case CLASS_ASSERTIONS: {
                return this.isRealized();
            }
        }
        return this.reasoner.isPrecomputed(inferenceType);
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        for (InferenceType inferenceType : inferenceTypes) {
            switch (inferenceType) {
                case CLASS_HIERARCHY: {
                    this.classify();
                }
                case CLASS_ASSERTIONS: {
                    this.realize();
                }
            }
            this.reasoner.precomputeInferences(inferenceTypes);
        }
    }

    public class DisjointClassComparator
    implements PartialOrderComparator<OWLClass> {
        private static final String ANONYMOUS_COMPLEMENT_REPRESENTATION_BASE = "http://clarkparsia.com/pellet/complement/";
        private static final String COMPLEMENT_POSTFIX = "-complement";
        private final OWLClassExpression complementClass;
        private final OWLClass complementRepresentation;

        public DisjointClassComparator(Taxonomy<OWLClass> taxonomy, OWLClassExpression originalClass) {
            this.complementClass = OWL.factory.getOWLObjectComplementOf(originalClass);
            this.complementRepresentation = this.generateComplementRepresentation(taxonomy, originalClass);
        }

        private OWLClass generateComplementRepresentation(Taxonomy<OWLClass> taxonomy, OWLClassExpression originalClass) {
            OWLClass complementClass = null;
            if (!originalClass.isAnonymous() && originalClass instanceof OWLClass) {
                return OWL.factory.getOWLClass(IRI.create((String)(((OWLClass)originalClass).getIRI() + COMPLEMENT_POSTFIX)));
            }
            while (taxonomy.contains((Object)(complementClass = OWL.factory.getOWLClass(IRI.create((String)(ANONYMOUS_COMPLEMENT_REPRESENTATION_BASE + IncrementalReasoner.this.RND.nextLong())))))) {
            }
            return complementClass;
        }

        public OWLClass getComplementRepresentation() {
            return this.complementRepresentation;
        }

        public PartialOrderRelation compare(OWLClass a, OWLClass b) {
            OWLClass aExpression = a;
            OWLClass bExpression = b;
            if (a.equals(this.complementRepresentation)) {
                aExpression = this.complementClass;
            }
            if (b.equals(this.complementRepresentation)) {
                bExpression = this.complementClass;
            }
            OWLSubClassOfAxiom aSubClassBAxiom = OWL.factory.getOWLSubClassOfAxiom((OWLClassExpression)aExpression, (OWLClassExpression)bExpression);
            OWLSubClassOfAxiom bSubClassAAxiom = OWL.factory.getOWLSubClassOfAxiom((OWLClassExpression)bExpression, (OWLClassExpression)aExpression);
            boolean aLessB = IncrementalReasoner.this.reasoner.isEntailed((OWLAxiom)aSubClassBAxiom);
            boolean bLessA = IncrementalReasoner.this.reasoner.isEntailed((OWLAxiom)bSubClassAAxiom);
            if (aLessB && bLessA) {
                return PartialOrderRelation.EQUAL;
            }
            if (aLessB) {
                return PartialOrderRelation.LESS;
            }
            if (bLessA) {
                return PartialOrderRelation.GREATER;
            }
            return PartialOrderRelation.INCOMPARABLE;
        }
    }

    private static interface Persistence {
        public static final String TAXONOMY_FILE_NAME = "Taxonomy";
        public static final String PROPERTIES_FILE_NAME = "Properties";
        public static final String PROPERTIES_FILE_COMMENT = "Properties of the IncrementalClassifier";
        public static final String REALIZED_PROPERTY = "realized";
        public static final String ONTOLOGY_IRI_PROPERTY = "ontologyIRI";
    }
}

