/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.AbstractModuleExtractor;
import com.clarkparsia.modularity.GraphBuilder;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.reachability.EntityNode;
import com.clarkparsia.reachability.Node;
import com.clarkparsia.reachability.PairSet;
import com.clarkparsia.reachability.Reachability;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;

public class GraphBasedModuleExtractor
extends AbstractModuleExtractor {
    public static final Logger log = Logger.getLogger(GraphBasedModuleExtractor.class.getName());

    public GraphBasedModuleExtractor() {
    }

    private GraphBasedModuleExtractor(GraphBasedModuleExtractor extractor) {
        super(extractor);
    }

    @Override
    public ModuleExtractor copy() {
        return new GraphBasedModuleExtractor(this);
    }

    @Override
    protected void extractModuleSignatures(Set<? extends OWLEntity> entities, ProgressMonitor monitor) {
        Timer t = this.getTimers().startTimer("buildGraph");
        GraphBuilder builder = new GraphBuilder();
        for (OWLAxiom axiom : this.getAxioms()) {
            builder.addAxiom(axiom);
        }
        Reachability<OWLEntity> engine = new Reachability<OWLEntity>(builder.build());
        t.stop();
        if (log.isLoggable(Level.FINER)) {
            log.finer(String.format("Built graph in %d ms", t.getLast()));
        }
        for (OWLEntity oWLEntity : entities) {
            Set<OWLEntity> module;
            if (!(oWLEntity instanceof OWLClass)) {
                monitor.incrementProgress();
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Compute module for " + oWLEntity);
            }
            if ((module = (Set<OWLEntity>)this.modules.get(oWLEntity)) != null) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Existing module size " + module.size());
                continue;
            }
            EntityNode<OWLEntity> node = engine.getGraph().getNode(oWLEntity);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Node " + node);
            }
            if (node == null) {
                module = Collections.singleton(oWLEntity);
                this.modules.put(oWLEntity, module);
                continue;
            }
            this.extractModule(engine, node, entities, monitor);
        }
    }

    private Set<OWLEntity> extractModule(Reachability<OWLEntity> engine, EntityNode<OWLEntity> node, Set<? extends OWLEntity> entities, ProgressMonitor monitor) {
        Node output;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Extract module for " + node);
        }
        Set<OWLEntity> module = null;
        for (OWLEntity n : node.getEntities()) {
            module = (Set<OWLEntity>)this.modules.get(n);
            if (module == null) continue;
            if (!log.isLoggable(Level.FINE)) break;
            log.fine("Existing module size " + module.size());
            break;
        }
        if (module == null && node.getOutputs().size() == 1 && (output = node.getOutputs().iterator().next()) instanceof EntityNode) {
            Set<OWLEntity> outputModule = this.extractModule(engine, (EntityNode)output, entities, monitor);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Cached module size " + outputModule.size());
            }
            module = new PairSet<OWLEntity>(outputModule, node.getEntities());
        }
        if (module == null) {
            module = engine.computeReachable(node.getEntities());
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting the module for " + node.getEntities());
        }
        for (OWLEntity n : node.getEntities()) {
            Set<OWLEntity> prevModule = this.modules.put(n, module);
            if (prevModule != null) {
                if (prevModule.equals(module)) continue;
                log.warning(String.format("Possible discrepancy for the module of %s ( Previous %s , Current %s )", n, prevModule, module));
                continue;
            }
            if (!entities.contains(n)) continue;
            monitor.incrementProgress();
        }
        return module;
    }

    @Override
    public Set<OWLAxiom> extractModule(Set<? extends OWLEntity> signature) {
        throw new UnsupportedOperationException();
    }
}

