/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.CompositionBase;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class Delta
extends CompositionBase
implements Graph {
    private Graph base;
    private Graph additions;
    private Graph deletions;

    public Delta(Graph base) {
        this.base = base;
        this.additions = Factory.createGraphMem();
        this.deletions = Factory.createGraphMem();
    }

    public Graph getAdditions() {
        return this.additions;
    }

    public Graph getDeletions() {
        return this.deletions;
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.base.contains(t)) {
            this.additions.add(t);
        }
        this.deletions.delete(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.additions.delete(t);
        if (this.base.contains(t)) {
            this.deletions.add(t);
        }
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple t) {
        ExtendedIterator<Triple> iterator = this.base.find(t).filterDrop(Delta.ifIn(GraphUtil.findAll(this.deletions))).andThen(this.additions.find(t));
        return SimpleEventManager.notifyingRemove(this, iterator);
    }

    @Override
    public void close() {
        super.close();
        this.base.close();
        this.additions.close();
        this.deletions.close();
    }

    @Override
    public int graphBaseSize() {
        return this.base.size() + this.additions.size() - this.deletions.size();
    }
}

