/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.tableau.completion.incremental.DependencyIndex;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.intset.IntSet;
import org.mindswap.pellet.utils.intset.IntSetFactory;

public class DependencySet {
    public static final Logger log = Logger.getLogger(DependencySet.class.getName());
    public static final int NO_BRANCH = -1;
    public static final DependencySet EMPTY;
    public static final DependencySet INDEPENDENT;
    public static final IntSet ZERO;
    public static final DependencySet DUMMY;
    private IntSet depends;
    private int branch = NO_BRANCH;
    private Set<ATermAppl> explain;

    private DependencySet() {
        this.depends = IntSetFactory.create();
        this.setExplain(SetUtils.emptySet());
    }

    public DependencySet(int branch) {
        this.depends = IntSetFactory.create();
        this.depends.add(branch);
        this.setExplain(SetUtils.emptySet());
    }

    private DependencySet(int branch, IntSet depends, Set<ATermAppl> explain) {
        this.branch = branch;
        this.depends = depends;
        this.setExplain(explain);
    }

    public DependencySet(ATermAppl explainAtom) {
        this.depends = ZERO;
        this.setExplain(SetUtils.singleton(explainAtom));
    }

    public DependencySet(Set<ATermAppl> explain) {
        this.depends = ZERO;
        this.setExplain(explain);
    }

    public DependencySet copy(int newBranch) {
        return new DependencySet(newBranch, this.depends, this.explain);
    }

    public boolean contains(int b) {
        return this.depends.contains(b);
    }

    public void add(int b) {
        this.depends.add(b);
    }

    public void remove(int b) {
        this.depends.remove(b);
    }

    public boolean isIndependent() {
        return this.max() <= 0;
    }

    public int getBranch() {
        return this.branch;
    }

    public int size() {
        return this.depends.size();
    }

    public int max() {
        return this.depends.isEmpty() ? -1 : this.depends.max();
    }

    public DependencySet union(IntSet set) {
        return new DependencySet(this.branch, this.depends.union(set), this.explain);
    }

    public DependencySet union(DependencySet ds, boolean doExplanation) {
        IntSet newDepends = this.depends.union(ds.depends);
        Set<Object> newExplain = doExplanation ? SetUtils.union(this.explain, ds.explain) : SetUtils.emptySet();
        return new DependencySet(this.branch, newDepends, newExplain);
    }

    public DependencySet union(Set<ATermAppl> explain, boolean doExplanation) {
        if (!doExplanation || explain.isEmpty()) {
            return this;
        }
        return new DependencySet(this.branch, this.depends.copy(), SetUtils.union(this.explain, explain));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.branch);
        sb.append("-");
        sb.append(this.depends);
        if (log.isLoggable(Level.FINE)) {
            sb.append(" ");
            sb.append(this.explain);
        }
        sb.append("]");
        return sb.toString();
    }

    public void removeExplain(ATermAppl assertion) {
        if (this.getExplain().contains(assertion)) {
            this.setExplain(new HashSet<ATermAppl>());
            if (DependencyIndex.log.isLoggable(Level.FINE)) {
                DependencyIndex.log.fine("             Explain: removed ");
            }
        }
    }

    public void setDepends(IntSet depends) {
        this.depends = depends;
    }

    public IntSet getDepends() {
        return this.depends;
    }

    public void setExplain(Set<ATermAppl> explain) {
        this.explain = explain;
    }

    public Set<ATermAppl> getExplain() {
        return this.explain;
    }

    public DependencySet cache() {
        if (this.isIndependent()) {
            return INDEPENDENT;
        }
        return DUMMY;
    }

    static {
        ZERO = IntSetFactory.create();
        ZERO.add(0);
        EMPTY = new DependencySet();
        INDEPENDENT = new DependencySet(0);
        DUMMY = new DependencySet(1);
    }
}

