/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AbstractDerivedIntegerType
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal XSD_DECIMAL = XSDDecimal.getInstance();
    private final RestrictedDatatype<Number> dataRange;

    public AbstractDerivedIntegerType(ATermAppl name, Number lower, Number upper) {
        super(name);
        if (lower != null && !OWLRealUtils.isInteger(lower)) {
            throw new IllegalArgumentException();
        }
        if (upper != null && !OWLRealUtils.isInteger(upper)) {
            throw new IllegalArgumentException();
        }
        if (lower != null && upper != null && OWLRealUtils.compare(lower, upper) > 0) {
            throw new IllegalArgumentException();
        }
        IntegerInterval i = new IntegerInterval(lower == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(lower), upper == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(upper));
        this.dataRange = new RestrictedRealDatatype(this, i, null, null);
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    protected abstract Number fromLexicalForm(String var1) throws InvalidLiteralException;

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(input);
        this.fromLexicalForm(lexicalForm);
        return XSD_DECIMAL.getCanonicalRepresentation(ATermUtils.makeTypedLiteral(lexicalForm, XSD_DECIMAL.getName()));
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        return OWLRealUtils.getCanonicalObject(this.fromLexicalForm(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

