/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.reachability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class Node {
    protected Set<Node> outputs = new HashSet<Node>();
    protected Set<Node> inputs = new HashSet<Node>();

    public void addOutput(Node output) {
        if (output.equals(this)) {
            return;
        }
        if (this.outputs.add(output)) {
            output.inputs.add(this);
        }
    }

    public boolean hasOutput(Node node) {
        return this.outputs.contains(node);
    }

    public Set<Node> getInputs() {
        return Collections.unmodifiableSet(this.inputs);
    }

    public Set<Node> getOutputs() {
        return Collections.unmodifiableSet(this.outputs);
    }

    public abstract boolean inputActivated();

    public abstract boolean isActive();

    public boolean isRedundant() {
        return false;
    }

    public void removeOutput(Node output) {
        if (this.outputs.remove(output)) {
            output.inputs.remove(output);
        }
    }

    public void removeInOuts() {
        for (Node input : this.inputs) {
            input.outputs.remove(this);
        }
        this.inputs = null;
        for (Node output : this.outputs) {
            output.inputs.remove(this);
        }
        this.outputs = null;
    }

    public void remove() {
        for (Node input : this.inputs) {
            input.outputs.remove(this);
            for (Node output : this.outputs) {
                input.addOutput(output);
            }
        }
        for (Node output : this.outputs) {
            output.inputs.remove(this);
        }
        this.inputs = null;
        this.outputs = null;
    }

    public abstract void reset();
}

