/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.modularity.ModularityUtils;
import com.clarkparsia.owlapiv3.OWL;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class ModularityExample {
    private static final String file = "file:examples/data/simple-galen.owl";
    private static final String NS = "http://www.co-ode.org/ontologies/galen#";

    private void run() throws Exception {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.loadOntology(IRI.create((String)file));
        System.out.println("The ontology contains " + ontology.getLogicalAxiomCount() + " axioms, " + ontology.getClassesInSignature().size() + " classes, and " + ontology.getObjectPropertiesInSignature().size() + " properties");
        HashSet<OWLClass> signature = new HashSet<OWLClass>();
        signature.add(OWL.Class((String)"http://www.co-ode.org/ontologies/galen#Heart"));
        signature.add(OWL.Class((String)"http://www.co-ode.org/ontologies/galen#Liver"));
        signature.add(OWL.Class((String)"http://www.co-ode.org/ontologies/galen#BloodPressure"));
        ModuleType moduleType = ModuleType.BOT_OF_TOP;
        Set moduleAxioms = ModularityUtils.extractModule((OWLOntology)ontology, signature, (ModuleType)moduleType);
        OWLOntology moduleOnt = manager.createOntology(moduleAxioms);
        System.out.println("The module contains " + moduleOnt.getLogicalAxiomCount() + " axioms, " + moduleOnt.getClassesInSignature().size() + " classes, and " + moduleOnt.getObjectPropertiesInSignature().size() + " properties");
    }

    public static void main(String[] args) throws Exception {
        ModularityExample app = new ModularityExample();
        app.run();
    }
}

