/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class IndividualsExample {
    public static void main(String[] args) throws Exception {
        System.out.println("Results using Jena interface");
        System.out.println("----------------------------");
        IndividualsExample.runWithJena();
        System.out.println("Results using OWL-API interface");
        System.out.println("-------------------------------");
        IndividualsExample.runWithOWLAPI();
    }

    public static void runWithJena() {
        String ont = "http://www.mindswap.org/2004/owl/mindswappers#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ont);
        model.prepare();
        OntClass Person = model.getOntClass("http://xmlns.com/foaf/0.1/Person");
        Property workHomepage = model.getProperty("http://xmlns.com/foaf/0.1/workInfoHomepage");
        Property foafName = model.getProperty("http://xmlns.com/foaf/0.1/name");
        ExtendedIterator i = Person.listInstances();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            String name = ((Literal)ind.getPropertyValue(foafName)).getString();
            Resource type = ind.getRDFType();
            Resource homepage = (Resource)ind.getPropertyValue(workHomepage);
            System.out.println("Name: " + name);
            System.out.println("Type: " + type.getLocalName());
            if (homepage == null) {
                System.out.println("Homepage: Unknown");
            } else {
                System.out.println("Homepage: " + homepage);
            }
            System.out.println();
        }
    }

    public static void runWithOWLAPI() throws OWLException {
        String ont = "http://www.mindswap.org/2004/owl/mindswappers#";
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = manager.loadOntology(IRI.create((String)ont));
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        OWLClass Person = factory.getOWLClass(IRI.create((String)"http://xmlns.com/foaf/0.1/Person"));
        OWLObjectProperty workHomepage = factory.getOWLObjectProperty(IRI.create((String)"http://xmlns.com/foaf/0.1/workInfoHomepage"));
        OWLDataProperty foafName = factory.getOWLDataProperty(IRI.create((String)"http://xmlns.com/foaf/0.1/name"));
        Set individuals = reasoner.getInstances((OWLClassExpression)Person, false).getFlattened();
        for (OWLNamedIndividual ind : individuals) {
            Set names = reasoner.getDataPropertyValues(ind, foafName);
            NodeSet types = reasoner.getTypes(ind, true);
            NodeSet homepages = reasoner.getObjectPropertyValues(ind, (OWLObjectPropertyExpression)workHomepage);
            String name = ((OWLLiteral)names.iterator().next()).getLiteral();
            System.out.println("Name: " + name);
            OWLClass type = (OWLClass)((Node)types.iterator().next()).getRepresentativeElement();
            System.out.println("Type:" + type);
            if (homepages.isEmpty()) {
                System.out.print("Homepage: Unknown");
            } else {
                System.out.print("Homepage:");
                for (Node homepage : homepages) {
                    System.out.print(" " + ((OWLNamedIndividual)homepage.getRepresentativeElement()).getIRI());
                }
            }
            System.out.println();
            System.out.println();
        }
    }
}

