/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.owlapiv3.OWL;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class IncrementalClassifierExample {
    private static final String file = "file:examples/data/simple-galen.owl";
    private static final String NS = "http://www.co-ode.org/ontologies/galen#";

    public void run() throws OWLOntologyCreationException {
        OWLOntology ontology = OWL.manager.loadOntology(IRI.create((String)file));
        OWLClass headache = OWL.Class((String)"http://www.co-ode.org/ontologies/galen#Headache");
        OWLClass pain = OWL.Class((String)"http://www.co-ode.org/ontologies/galen#Pain");
        IncrementalClassifier classifier = new IncrementalClassifier(ontology);
        Timers timers = new Timers();
        Timer t = timers.createTimer("First classification");
        t.start();
        classifier.classify();
        t.stop();
        System.out.println("\nClassification time: " + t.getTotal() + "ms");
        System.out.println("Subclasses of " + pain + ": " + classifier.getSubClasses((OWLClassExpression)pain, true).getFlattened() + "\n");
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)headache, (OWLClassExpression)pain);
        OWL.manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)axiom));
        t = timers.createTimer("Second classification");
        t.start();
        classifier.classify();
        t.stop();
        System.out.println("\nClassification time: " + t.getTotal() + "ms");
        System.out.println("Subclasses of " + pain + ": " + classifier.getSubClasses((OWLClassExpression)pain, true).getFlattened() + "\n");
        OWL.manager.applyChange((OWLOntologyChange)new RemoveAxiom(ontology, (OWLAxiom)axiom));
        timers.startTimer("Third classification");
        classifier.classify();
        timers.stopTimer("Third classification");
        System.out.println("\nClassification time: " + t.getTotal() + "ms");
        System.out.println("Subclasses of " + pain + ": " + classifier.getSubClasses((OWLClassExpression)pain, true).getFlattened() + "\n");
        System.out.println("Timers summary");
        for (Timer timer : timers.getTimers()) {
            if (timer.isStarted()) continue;
            System.out.println(timer.getName() + ": " + timer.getTotal() + "ms");
        }
    }

    public static void main(String[] args) throws OWLOntologyCreationException {
        IncrementalClassifierExample app = new IncrementalClassifierExample();
        app.run();
    }
}

