/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.owlapi.explanation.PelletExplanation;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxExplanationRenderer;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class ExplanationExample {
    private static final String file = "file:examples/data/people+pets.owl";
    private static final String NS = "http://cohse.semanticweb.org/ontologies/people#";

    public void run() throws OWLOntologyCreationException, OWLException, IOException {
        PelletExplanation.setup();
        ManchesterSyntaxExplanationRenderer renderer = new ManchesterSyntaxExplanationRenderer();
        PrintWriter out = new PrintWriter(System.out);
        renderer.startRendering((Writer)out);
        OWLOntologyManager manager = OWL.manager;
        OWLOntology ontology = manager.loadOntology(IRI.create((String)file));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation expGen = new PelletExplanation(reasoner);
        OWLClass madCow = OWL.Class((String)"http://cohse.semanticweb.org/ontologies/people#mad+cow");
        OWLClass animalLover = OWL.Class((String)"http://cohse.semanticweb.org/ontologies/people#animal+lover");
        OWLClass petOwner = OWL.Class((String)"http://cohse.semanticweb.org/ontologies/people#pet+owner");
        Set exp = expGen.getUnsatisfiableExplanations((OWLClassExpression)madCow);
        out.println("Why is " + madCow + " concept unsatisfiable?");
        renderer.render(exp);
        exp = expGen.getSubClassExplanations((OWLClassExpression)animalLover, (OWLClassExpression)petOwner);
        out.println("Why is " + animalLover + " subclass of " + petOwner + "?");
        renderer.render(exp);
        renderer.endRendering();
    }

    public static void main(String[] args) throws OWLOntologyCreationException, OWLException, IOException {
        ExplanationExample app = new ExplanationExample();
        app.run();
    }
}

