/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLAPIOwl2Obo {
    private static Logger LOG = Logger.getLogger(OWLAPIOwl2Obo.class.getName());
    protected OWLOntologyManager manager;
    protected OWLOntology owlOntology;
    protected OWLDataFactory fac;
    protected OBODoc obodoc;
    protected Set<OWLAxiom> untranslatableAxioms;
    protected Map<String, String> idSpaceMap;
    public static Map<String, String> annotationPropertyMap = OWLAPIOwl2Obo.initAnnotationPropertyMap();
    protected Set<OWLAnnotationProperty> apToDeclare;
    protected String ontologyId;
    protected boolean strictConversion;
    protected boolean discardUntranslatable = false;
    protected Pattern absoulteURLPattern = Pattern.compile("<\\s*http.*?>");

    protected void init() {
        this.idSpaceMap = new HashMap<String, String>();
        this.idSpaceMap.put("http://www.obofoundry.org/ro/ro.owl#", "OBO_REL");
        this.untranslatableAxioms = new HashSet<OWLAxiom>();
        this.fac = this.manager.getOWLDataFactory();
        this.apToDeclare = new HashSet<OWLAnnotationProperty>();
    }

    public OWLAPIOwl2Obo(OWLOntologyManager translationManager) {
        this.manager = translationManager;
        this.init();
    }

    protected static HashMap<String, String> initAnnotationPropertyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : OWLAPIObo2Owl.annotationPropertyMap.keySet()) {
            IRI propIRI = OWLAPIObo2Owl.annotationPropertyMap.get(key);
            map.put(propIRI.toString(), key);
        }
        return map;
    }

    public void setStrictConversion(boolean b) {
        this.strictConversion = b;
    }

    public boolean getStrictConversion() {
        return this.strictConversion;
    }

    public boolean isDiscardUntranslatable() {
        return this.discardUntranslatable;
    }

    public void setDiscardUntranslatable(boolean discardUntranslatable) {
        this.discardUntranslatable = discardUntranslatable;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OBODoc getObodoc() {
        return this.obodoc;
    }

    public void setObodoc(OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    public OBODoc convert(OWLOntology ont) {
        this.owlOntology = ont;
        this.ontologyId = ont != null ? OWLAPIOwl2Obo.getOntologyId(ont) : "TODO";
        this.init();
        return this.tr();
    }

    public Collection<OWLAxiom> getUntranslatableAxioms() {
        return this.untranslatableAxioms;
    }

    protected OBODoc tr() {
        this.obodoc = new OBODoc();
        this.preProcess();
        this.tr(this.owlOntology);
        for (OWLAxiom ax : this.owlOntology.getAxioms()) {
            if (ax instanceof OWLDeclarationAxiom) {
                this.tr((OWLDeclarationAxiom)ax);
                continue;
            }
            if (ax instanceof OWLSubClassOfAxiom) {
                this.tr((OWLSubClassOfAxiom)ax);
                continue;
            }
            if (ax instanceof OWLDisjointClassesAxiom) {
                this.tr((OWLDisjointClassesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLEquivalentClassesAxiom) {
                this.tr((OWLEquivalentClassesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLClassAssertionAxiom) {
                this.tr((OWLClassAssertionAxiom)ax);
                continue;
            }
            if (ax instanceof OWLEquivalentObjectPropertiesAxiom) {
                this.tr((OWLEquivalentObjectPropertiesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLSubAnnotationPropertyOfAxiom) {
                this.tr((OWLSubAnnotationPropertyOfAxiom)ax);
                continue;
            }
            if (ax instanceof OWLSubObjectPropertyOfAxiom) {
                this.tr((OWLSubObjectPropertyOfAxiom)ax);
                continue;
            }
            if (ax instanceof OWLObjectPropertyRangeAxiom) {
                this.tr((OWLObjectPropertyRangeAxiom)ax);
                continue;
            }
            if (ax instanceof OWLFunctionalObjectPropertyAxiom) {
                this.tr((OWLFunctionalObjectPropertyAxiom)ax);
                continue;
            }
            if (ax instanceof OWLSymmetricObjectPropertyAxiom) {
                this.tr((OWLSymmetricObjectPropertyAxiom)ax);
                continue;
            }
            if (ax instanceof OWLAsymmetricObjectPropertyAxiom) {
                this.tr((OWLAsymmetricObjectPropertyAxiom)ax);
                continue;
            }
            if (ax instanceof OWLObjectPropertyDomainAxiom) {
                this.tr((OWLObjectPropertyDomainAxiom)ax);
                continue;
            }
            if (ax instanceof OWLInverseFunctionalObjectPropertyAxiom) {
                this.tr((OWLInverseFunctionalObjectPropertyAxiom)ax);
                continue;
            }
            if (ax instanceof OWLInverseObjectPropertiesAxiom) {
                this.tr((OWLInverseObjectPropertiesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLDisjointObjectPropertiesAxiom) {
                this.tr((OWLDisjointObjectPropertiesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLReflexiveObjectPropertyAxiom) {
                this.tr((OWLReflexiveObjectPropertyAxiom)ax);
                continue;
            }
            if (ax instanceof OWLTransitiveObjectPropertyAxiom) {
                this.tr((OWLTransitiveObjectPropertyAxiom)ax);
                continue;
            }
            if (ax instanceof OWLSubPropertyChainOfAxiom) {
                this.tr((OWLSubPropertyChainOfAxiom)ax);
                continue;
            }
            if (ax instanceof OWLAnnotationAssertionAxiom) continue;
            this.error(ax);
        }
        if (!this.untranslatableAxioms.isEmpty() && !this.discardUntranslatable) {
            try {
                String axiomString = OwlStringTools.translate(this.untranslatableAxioms, this.manager);
                if (axiomString != null) {
                    Frame headerFrame = this.obodoc.getHeaderFrame();
                    if (headerFrame == null) {
                        headerFrame = new Frame(Frame.FrameType.HEADER);
                        this.obodoc.setHeaderFrame(headerFrame);
                    }
                    headerFrame.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS, axiomString));
                }
            }
            catch (OwlStringTools.OwlStringException e) {
                throw new RuntimeException(e);
            }
        }
        return this.obodoc;
    }

    protected void preProcess() {
        String viewRel = null;
        for (OWLAnnotation ann : this.owlOntology.getAnnotations()) {
            if (!ann.getProperty().getIRI().equals((Object)Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation.getIRI())) continue;
            OWLAnnotationValue v = ann.getValue();
            if (v instanceof OWLLiteral) {
                viewRel = ((OWLLiteral)v).getLiteral();
                break;
            }
            viewRel = this.getIdentifierUsingBaseOntology((IRI)v);
            break;
        }
        if (viewRel != null) {
            HashSet<OWLEquivalentClassesAxiom> rmAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            HashSet<OWLEquivalentClassesAxiom> newAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            for (OWLEquivalentClassesAxiom eca : this.owlOntology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                int numNamed = 0;
                HashSet<Object> xs = new HashSet<Object>();
                for (OWLClassExpression x : eca.getClassExpressions()) {
                    if (x instanceof OWLClass) {
                        xs.add(x);
                        ++numNamed;
                        continue;
                    }
                    if (x instanceof OWLObjectSomeValuesFrom) {
                        OWLObjectProperty p = (OWLObjectProperty)((OWLObjectSomeValuesFrom)x).getProperty();
                        if (!this.getIdentifier((OWLObject)p).equals(viewRel)) {
                            LOG.log(Level.SEVERE, "Expected: " + viewRel + " got: " + p + " in " + eca);
                        }
                        xs.add(((OWLObjectSomeValuesFrom)x).getFiller());
                        continue;
                    }
                    LOG.log(Level.SEVERE, "Unexpected: " + eca);
                }
                if (numNamed == 1) {
                    rmAxioms.add(eca);
                    newAxioms.add(this.fac.getOWLEquivalentClassesAxiom(xs));
                    continue;
                }
                LOG.log(Level.SEVERE, "ECA did not fit expected pattern: " + eca);
            }
            this.manager.removeAxioms(this.owlOntology, rmAxioms);
            this.manager.addAxioms(this.owlOntology, newAxioms);
        }
    }

    protected void add(Frame f) {
        if (f != null) {
            try {
                this.obodoc.addFrame(f);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    protected boolean trObjectProperty(OWLObjectProperty prop, String tag, String value, Set<OWLAnnotation> annotations) {
        Clause clause;
        if (prop == null || value == null) {
            return false;
        }
        Frame f = this.getTypedefFrame((OWLEntity)prop);
        if (OBOFormatConstants.OboFormatTag.TAG_ID.getTag().equals(tag)) {
            clause = f.getClause(tag);
            if (tag != null) {
                clause.setValue(value);
            } else {
                clause = new Clause(tag, value);
                f.addClause(clause);
            }
        } else {
            clause = new Clause(tag, value);
            f.addClause(clause);
        }
        this.addQualifiers(clause, annotations);
        return true;
    }

    protected boolean trObjectProperty(OWLObjectProperty prop, String tag, Boolean value, Set<OWLAnnotation> annotations) {
        if (prop == null || value == null) {
            return false;
        }
        Frame f = this.getTypedefFrame((OWLEntity)prop);
        Clause clause = new Clause(tag);
        clause.addValue(value);
        f.addClause(clause);
        this.addQualifiers(clause, annotations);
        return true;
    }

    protected void trNaryPropertyAxiom(OWLNaryPropertyAxiom<OWLObjectPropertyExpression> ax, String tag) {
        Set set = ax.getProperties();
        if (set.size() > 1) {
            boolean first = true;
            OWLObjectProperty prop = null;
            String disjointFrom = null;
            for (OWLObjectPropertyExpression ex : set) {
                if (ex.isBottomEntity() || ex.isTopEntity()) {
                    this.error(tag + " using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax);
                    return;
                }
                if (first) {
                    first = false;
                    if (!(ex instanceof OWLObjectProperty)) continue;
                    prop = (OWLObjectProperty)ex;
                    continue;
                }
                disjointFrom = this.getIdentifier((OWLObject)ex);
            }
            if (this.trObjectProperty(prop, tag, disjointFrom, (Set<OWLAnnotation>)ax.getAnnotations())) {
                return;
            }
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLSubPropertyChainOfAxiom ax) {
        Clause clause;
        OWLObjectPropertyExpression pEx = ax.getSuperProperty();
        if (pEx.isAnonymous()) {
            this.error((OWLAxiom)ax);
            return;
        }
        OWLObjectProperty p = pEx.asOWLObjectProperty();
        Frame f = this.getTypedefFrame((OWLEntity)p);
        if (p.isBottomEntity() || p.isTopEntity()) {
            this.error("Property chains using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax);
            return;
        }
        List list = ax.getPropertyChain();
        if (list.size() != 2) {
            this.error((OWLAxiom)ax);
            return;
        }
        OWLObjectPropertyExpression exp1 = (OWLObjectPropertyExpression)list.get(0);
        OWLObjectPropertyExpression exp2 = (OWLObjectPropertyExpression)list.get(1);
        if (exp1.isBottomEntity() || exp1.isTopEntity() || exp2.isBottomEntity() || exp2.isTopEntity()) {
            this.error("Property chains using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax);
            return;
        }
        String rel1 = this.getIdentifier((OWLObject)exp1);
        String rel2 = this.getIdentifier((OWLObject)exp2);
        if (rel1 == null || rel2 == null) {
            this.error((OWLAxiom)ax);
            return;
        }
        HashSet<OWLAnnotation> unprocessedAnnotations = new HashSet<OWLAnnotation>(ax.getAnnotations());
        if (rel1.equals(f.getId())) {
            clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER, rel2);
        } else {
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                if (!"http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain".equals(ann.getProperty().getIRI().toString())) continue;
                tag = OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN;
                unprocessedAnnotations.remove(ann);
                break;
            }
            clause = new Clause(tag);
            clause.addValue(rel1);
            clause.addValue(rel2);
        }
        f.addClause(clause);
        this.addQualifiers(clause, unprocessedAnnotations);
    }

    protected void tr(OWLEquivalentObjectPropertiesAxiom ax) {
        this.trNaryPropertyAxiom((OWLNaryPropertyAxiom<OWLObjectPropertyExpression>)ax, OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
    }

    protected void tr(OWLTransitiveObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLDisjointObjectPropertiesAxiom ax) {
        this.trNaryPropertyAxiom((OWLNaryPropertyAxiom<OWLObjectPropertyExpression>)ax, OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
    }

    protected void tr(OWLReflexiveObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLInverseFunctionalObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLInverseObjectPropertiesAxiom ax) {
        OWLObjectPropertyExpression prop1 = ax.getFirstProperty();
        OWLObjectPropertyExpression prop2 = ax.getSecondProperty();
        if (prop1 instanceof OWLObjectProperty && prop2 instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop1, OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag(), this.getIdentifier((OWLObject)prop2), (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLObjectPropertyDomainAxiom ax) {
        OWLClassExpression domain = ax.getDomain();
        OWLObjectPropertyExpression propEx = (OWLObjectPropertyExpression)ax.getProperty();
        if (propEx.isAnonymous()) {
            this.error((OWLAxiom)ax);
            return;
        }
        OWLObjectProperty prop = propEx.asOWLObjectProperty();
        if (domain.isBottomEntity() || domain.isTopEntity()) {
            this.getTypedefFrame((OWLEntity)prop);
            this.error("domains using top or bottom entities are not translatable to OBO.", (OWLAxiom)ax);
            return;
        }
        String range = this.getIdentifier((OWLObject)domain);
        if (range != null && this.trObjectProperty(prop, OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag(), range, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLAsymmetricObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLSymmetricObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLFunctionalObjectPropertyAxiom ax) {
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)ax.getProperty();
        if (prop instanceof OWLObjectProperty && this.trObjectProperty((OWLObjectProperty)prop, OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL.getTag(), Boolean.TRUE, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLObjectPropertyRangeAxiom ax) {
        OWLClassExpression owlRange = (OWLClassExpression)ax.getRange();
        OWLObjectPropertyExpression propEx = (OWLObjectPropertyExpression)ax.getProperty();
        if (propEx.isAnonymous()) {
            this.error((OWLAxiom)ax);
        }
        OWLObjectProperty prop = propEx.asOWLObjectProperty();
        if (owlRange.isBottomEntity() || owlRange.isTopEntity()) {
            this.getTypedefFrame((OWLEntity)prop);
            this.error("ranges using top or bottom entities are not translatable to OBO.", (OWLAxiom)ax);
            return;
        }
        String range = this.getIdentifier((OWLObject)owlRange);
        if (range != null && this.trObjectProperty(prop, OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag(), range, (Set<OWLAnnotation>)ax.getAnnotations())) {
            return;
        }
        this.error((OWLAxiom)ax);
    }

    protected void tr(OWLSubObjectPropertyOfAxiom ax) {
        OWLObjectPropertyExpression sup = (OWLObjectPropertyExpression)ax.getSuperProperty();
        OWLObjectPropertyExpression sub = (OWLObjectPropertyExpression)ax.getSubProperty();
        if (sub.isBottomEntity() || sub.isTopEntity() || sup.isBottomEntity() || sub.isTopEntity()) {
            this.error("SubProperties using Top or Bottom entites are not supported in OBO.");
            return;
        }
        if (sub instanceof OWLObjectProperty && sup instanceof OWLObjectProperty) {
            String supId = this.getIdentifier((OWLObject)sup);
            if (supId.startsWith("owl:")) {
                return;
            }
            Frame f = this.getTypedefFrame((OWLEntity)((OWLObjectProperty)sub));
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, supId);
            f.addClause(clause);
            this.addQualifiers(clause, ax.getAnnotations());
        } else {
            this.error((OWLAxiom)ax);
        }
    }

    protected void tr(OWLSubAnnotationPropertyOfAxiom ax) {
        OWLAnnotationProperty sup = ax.getSuperProperty();
        OWLAnnotationProperty sub = ax.getSubProperty();
        if (sub.isBottomEntity() || sub.isTopEntity() || sup.isBottomEntity() || sub.isTopEntity()) {
            this.error("SubAnnotationProperties using Top or Bottom entites are not supported in OBO.");
            return;
        }
        String _tag = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)sup);
        if (OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag().equals(_tag)) {
            String name = "";
            String scope = null;
            for (OWLAnnotationAssertionAxiom axiom : sub.getAnnotationAssertionAxioms(this.owlOntology)) {
                String tg = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getProperty());
                if (OBOFormatConstants.OboFormatTag.TAG_NAME.getTag().equals(tg)) {
                    name = ((OWLLiteral)axiom.getValue()).getLiteral();
                    continue;
                }
                if (!OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag().equals(tg)) continue;
                scope = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getValue());
            }
            Frame hf = this.obodoc.getHeaderFrame();
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF);
            clause.addValue(this.getIdentifier((OWLObject)sub));
            clause.addValue(name);
            if (scope != null) {
                clause.addValue(scope);
            }
            this.addQualifiers(clause, ax.getAnnotations());
            if (!hf.getClauses().contains(clause)) {
                hf.addClause(clause);
            } else {
                LOG.log(Level.WARNING, "duplicate clause: " + clause + " in header");
            }
            return;
        }
        if (OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag().equals(_tag)) {
            String comment = "";
            for (OWLAnnotationAssertionAxiom axiom : sub.getAnnotationAssertionAxioms(this.owlOntology)) {
                String tg = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)axiom.getProperty());
                if (!OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(tg) || (comment = ((OWLLiteral)axiom.getValue()).getLiteral()) == null) continue;
                break;
            }
            Frame hf = this.obodoc.getHeaderFrame();
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF);
            clause.addValue(this.getIdentifier((OWLObject)sub));
            clause.addValue(comment);
            if (!hf.getClauses().contains(clause)) {
                hf.addClause(clause);
            } else {
                LOG.log(Level.WARNING, "duplicate clause: " + clause + " in header");
            }
            this.addQualifiers(clause, ax.getAnnotations());
            return;
        }
        if (sub instanceof OWLObjectProperty && sup instanceof OWLObjectProperty) {
            String supId = this.getIdentifier((OWLObject)sup);
            if (supId.startsWith("owl:")) {
                return;
            }
            Frame f = this.getTypedefFrame((OWLEntity)sub);
            Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A, supId);
            f.addClause(clause);
            this.addQualifiers(clause, ax.getAnnotations());
        } else {
            this.error((OWLAxiom)ax);
        }
    }

    protected void tr(OWLAnnotationAssertionAxiom aanAx, Frame frame) {
        boolean success = this.tr(aanAx.getProperty(), aanAx.getValue(), aanAx.getAnnotations(), frame);
        if (!success) {
            this.untranslatableAxioms.add((OWLAxiom)aanAx);
        }
    }

    protected boolean tr(OWLAnnotationProperty prop, OWLAnnotationValue annVal, Set<OWLAnnotation> qualifiers, Frame frame) {
        String tagString = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)prop);
        OBOFormatConstants.OboFormatTag tag = null;
        if (tagString != null) {
            tag = OBOFormatConstants.getTag(tagString);
        }
        if (tag == null) {
            String propId;
            if (annVal instanceof IRI && Frame.FrameType.TERM.equals((Object)frame.getType()) && this.isMetadataTag(prop) && (propId = this.getIdentifier((OWLObject)prop)) != null) {
                Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP);
                clause.addValue(propId);
                clause.addValue(OWLAPIOwl2Obo.getIdentifier((IRI)annVal));
                this.addQualifiers(clause, qualifiers);
                frame.addClause(clause);
                return true;
            }
            return this.trGenericPropertyValue(prop, annVal, qualifiers, frame);
        }
        String value = this.getValue(annVal, tagString);
        if (!value.isEmpty()) {
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ID) {
                if (!frame.getId().equals(value)) {
                    this.error("Conflicting id definitions: 1) " + frame.getId() + "  2)" + value);
                    return false;
                }
                return true;
            }
            Clause clause = new Clause(tag);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                try {
                    clause.addValue(OBOFormatConstants.headerDateFormat.get().parseObject(value));
                }
                catch (ParseException e) {
                    this.error("Could not parse date string: " + value);
                    return false;
                }
            } else {
                clause.addValue(value);
            }
            HashSet<OWLAnnotation> unprocessedQualifiers = new HashSet<OWLAnnotation>(qualifiers);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DEF) {
                for (OWLAnnotation aan : qualifiers) {
                    String propId = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)aan.getProperty());
                    if (!"xref".equals(propId)) continue;
                    OWLAnnotationValue v = aan.getValue();
                    String xrefValue = v instanceof IRI ? ((IRI)v).toString() : ((OWLLiteral)v).getLiteral();
                    Xref xref = new Xref(xrefValue);
                    clause.addXref(xref);
                    unprocessedQualifiers.remove(aan);
                }
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_XREF) {
                Xref xref = new Xref(value);
                for (OWLAnnotation annotation : qualifiers) {
                    OWLAnnotationValue owlAnnotationValue;
                    if (!this.fac.getRDFSLabel().equals(annotation.getProperty()) || !((owlAnnotationValue = annotation.getValue()) instanceof OWLLiteral)) continue;
                    unprocessedQualifiers.remove(annotation);
                    String xrefAnnotation = ((OWLLiteral)owlAnnotationValue).getLiteral();
                    if (xrefAnnotation == null || (xrefAnnotation = xrefAnnotation.trim()).length() <= 0) continue;
                    xref.setAnnotation(xrefAnnotation);
                }
                clause.setValue(xref);
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_EXACT || tag == OBOFormatConstants.OboFormatTag.TAG_NARROW || tag == OBOFormatConstants.OboFormatTag.TAG_BROAD || tag == OBOFormatConstants.OboFormatTag.TAG_RELATED) {
                this.handleSynonym(qualifiers, tag.getTag(), clause, unprocessedQualifiers);
            } else if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
                String synonymType = null;
                this.handleSynonym(qualifiers, synonymType, clause, unprocessedQualifiers);
            }
            this.addQualifiers(clause, unprocessedQualifiers);
            boolean redundant = false;
            for (Clause frameClause : frame.getClauses()) {
                if (!clause.equals(frameClause)) continue;
                redundant = this.handleDuplicateClause(frame, frameClause);
            }
            if (!redundant) {
                frame.addClause(clause);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isMetadataTag(OWLAnnotationProperty p) {
        IRI metadataTagIRI = IRI.create((String)("http://www.geneontology.org/formats/oboInOwl#" + OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag()));
        Set axioms = this.owlOntology.getAnnotationAssertionAxioms((OWLAnnotationSubject)p.getIRI());
        for (OWLAnnotationAssertionAxiom ax : axioms) {
            if (!metadataTagIRI.equals((Object)ax.getProperty().getIRI())) continue;
            return true;
        }
        return false;
    }

    protected void handleSynonym(Set<OWLAnnotation> qualifiers, String scope, Clause clause, Set<OWLAnnotation> unprocessedQualifiers) {
        clause.setTag(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag());
        String type = null;
        clause.setXrefs(new Vector<Xref>());
        for (OWLAnnotation aan : qualifiers) {
            String propId = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)aan.getProperty());
            if (OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(propId)) {
                OWLAnnotationValue v = aan.getValue();
                String xrefValue = v instanceof IRI ? ((IRI)v).toString() : ((OWLLiteral)v).getLiteral();
                Xref xref = new Xref(xrefValue);
                clause.addXref(xref);
                unprocessedQualifiers.remove(aan);
                continue;
            }
            if (!OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag().equals(propId)) continue;
            type = this.getIdentifier((OWLObject)aan.getValue());
            unprocessedQualifiers.remove(aan);
        }
        if (scope != null) {
            clause.addValue(scope);
            if (type != null) {
                clause.addValue(type);
            }
        }
    }

    protected boolean handleDuplicateClause(Frame frame, Clause clause) {
        LOG.log(Level.WARNING, "Duplicate clause '" + clause + "' generated in frame: " + frame.getId());
        return true;
    }

    protected boolean trGenericPropertyValue(OWLAnnotationProperty prop, OWLAnnotationValue annVal, Set<OWLAnnotation> qualifiers, Frame frame) {
        Clause clause = new Clause(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag());
        String propId = this.getIdentifier((OWLObject)prop);
        this.addQualifiers(clause, qualifiers);
        if (!propId.equals("shorthand")) {
            clause.addValue(propId);
            if (annVal instanceof OWLLiteral) {
                OWLLiteral owlLiteral = (OWLLiteral)annVal;
                clause.addValue(owlLiteral.getLiteral());
                OWLDatatype datatype = owlLiteral.getDatatype();
                IRI dataTypeIri = datatype.getIRI();
                if (!OWL2Datatype.isBuiltIn((IRI)dataTypeIri)) {
                    this.error("Untranslatable axiom due to unknown data type: " + annVal);
                    return false;
                }
                if (Namespaces.XSD.inNamespace(dataTypeIri)) {
                    clause.addValue(dataTypeIri.prefixedBy("xsd:"));
                } else if (dataTypeIri.isPlainLiteral()) {
                    clause.addValue("xsd:string");
                } else {
                    clause.addValue(dataTypeIri.toString());
                }
            } else if (annVal instanceof IRI) {
                clause.addValue(this.getIdentifierUsingBaseOntology((IRI)annVal));
            }
            frame.addClause(clause);
        }
        return true;
    }

    protected String getValue(OWLAnnotationValue annVal, String tag) {
        String value = annVal.toString();
        if (annVal instanceof OWLLiteral) {
            value = ((OWLLiteral)annVal).getLiteral();
        } else if (annVal instanceof IRI) {
            value = this.getIdentifierUsingBaseOntology((IRI)annVal);
        }
        if (OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(tag)) {
            Matcher matcher = this.absoulteURLPattern.matcher(value);
            while (matcher.find()) {
                String m = matcher.group();
                m = m.replace("<", "");
                m = m.replace(">", "");
                int i = m.lastIndexOf("/");
                m = m.substring(i + 1);
                value = value.replace(matcher.group(), m);
            }
        }
        return value;
    }

    protected void addQualifiers(Clause c, Set<OWLAnnotation> qualifiers) {
        for (OWLAnnotation ann : qualifiers) {
            String prop = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)ann.getProperty());
            if (prop == null) {
                prop = ann.getProperty().getIRI().toString();
            }
            if (prop.equals("gci_relation") || prop.equals("gci_filler") || prop.equals("cardinality") || prop.equals("minCardinality") || prop.equals("maxCardinality") || prop.equals("all_some") || prop.equals("all_only")) continue;
            String value = ann.getValue().toString();
            if (ann.getValue() instanceof OWLLiteral) {
                value = ((OWLLiteral)ann.getValue()).getLiteral();
            } else if (ann.getValue() instanceof IRI) {
                value = this.getIdentifierUsingBaseOntology((IRI)ann.getValue());
            }
            QualifierValue qv = new QualifierValue(prop, value);
            c.addQualifierValue(qv);
        }
    }

    public static String getOntologyId(OWLOntology ontology) {
        return OWLAPIOwl2Obo.getOntologyId(ontology.getOntologyID().getOntologyIRI());
    }

    public static String getOntologyId(IRI iriObj) {
        String id;
        String iri = iriObj.toString();
        if (iri.startsWith("http://purl.obolibrary.org/obo/")) {
            id = iri.replace("http://purl.obolibrary.org/obo/", "");
            if (id.endsWith(".owl")) {
                id = id.replaceFirst(".owl$", "");
            }
        } else {
            id = iri;
        }
        return id;
    }

    public static String getDataVersion(OWLOntology ontology) {
        String oid = OWLAPIOwl2Obo.getOntologyId(ontology);
        IRI v = ontology.getOntologyID().getVersionIRI();
        if (v != null) {
            String vs = v.toString().replace("http://purl.obolibrary.org/obo/", "");
            vs = vs.replaceFirst(oid + "/", "");
            vs = vs.replace("/" + oid + ".owl", "");
            return vs;
        }
        return null;
    }

    protected void tr(OWLOntology ontology) {
        Frame f = new Frame(Frame.FrameType.HEADER);
        this.obodoc.setHeaderFrame(f);
        for (IRI iri : ontology.getDirectImportsDocuments()) {
            Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IMPORT.getTag());
            c.setValue(iri.toString());
            f.addClause(c);
        }
        String id = OWLAPIOwl2Obo.getOntologyId(this.owlOntology);
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY.getTag());
        c.setValue(id);
        f.addClause(c);
        String vid = OWLAPIOwl2Obo.getDataVersion(this.owlOntology);
        if (vid != null) {
            Clause c2 = new Clause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION.getTag());
            c2.setValue(vid);
            f.addClause(c2);
        }
        for (OWLAnnotation ann : ontology.getAnnotations()) {
            OWLAnnotationProperty property = ann.getProperty();
            String tagString = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)property);
            if (OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(tagString)) {
                property = this.fac.getOWLAnnotationProperty(OWLAPIObo2Owl.trTagToIRI(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag()));
            }
            this.tr(property, ann.getValue(), ann.getAnnotations(), f);
        }
    }

    protected void tr(OWLEquivalentClassesAxiom ax) {
        ArrayList<Clause> equivalenceAxiomClauses;
        boolean isUntranslateable;
        Frame f;
        block25: {
            block27: {
                List list2;
                String cls2;
                OWLClassExpression ce2;
                block26: {
                    block24: {
                        Set expressions = ax.getClassExpressions();
                        if (expressions.size() != 2) {
                            this.error((OWLAxiom)ax);
                            return;
                        }
                        Iterator it = expressions.iterator();
                        OWLClassExpression ce1 = (OWLClassExpression)it.next();
                        ce2 = (OWLClassExpression)it.next();
                        if (ce1.isBottomEntity() || ce1.isTopEntity() || ce2.isBottomEntity() || ce2.isTopEntity()) {
                            this.error("Equivalent classes axioms using Top or Bottom entities are not supported in OBO.", (OWLAxiom)ax);
                            return;
                        }
                        if (!(ce1 instanceof OWLClass)) {
                            if (ce2 instanceof OWLClass) {
                                OWLClassExpression temp = ce2;
                                ce2 = ce1;
                                ce1 = temp;
                            } else {
                                this.error("GCI axioms are not expressible in OBO.", (OWLAxiom)ax);
                                return;
                            }
                        }
                        if ((f = this.getTermFrame(ce1.asOWLClass())) == null) {
                            this.error((OWLAxiom)ax);
                            return;
                        }
                        isUntranslateable = false;
                        equivalenceAxiomClauses = new ArrayList<Clause>();
                        cls2 = this.getIdentifier((OWLObject)ce2);
                        if (cls2 == null) break block24;
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
                        c.setValue(cls2);
                        f.addClause(c);
                        this.addQualifiers(c, ax.getAnnotations());
                        break block25;
                    }
                    if (!(ce2 instanceof OWLObjectUnionOf)) break block26;
                    list2 = ((OWLObjectUnionOf)ce2).getOperandsAsList();
                    for (OWLClassExpression oce : list2) {
                        String id = this.getIdentifier((OWLObject)oce);
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag());
                        if (id == null) {
                            isUntranslateable = true;
                            this.error((OWLAxiom)ax);
                            return;
                        }
                        c.setValue(id);
                        equivalenceAxiomClauses.add(c);
                        this.addQualifiers(c, ax.getAnnotations());
                    }
                    break block25;
                }
                if (!(ce2 instanceof OWLObjectIntersectionOf)) break block27;
                list2 = ((OWLObjectIntersectionOf)ce2).getOperandsAsList();
                for (OWLClassExpression ce : list2) {
                    Boolean allOnly;
                    Boolean allSome;
                    Integer max;
                    Integer min;
                    Integer exact;
                    String r;
                    block29: {
                        Set operands;
                        block33: {
                            OWLClassExpression filler;
                            OWLObjectAllValuesFrom all;
                            block34: {
                                block32: {
                                    OWLObjectExactCardinality card;
                                    block31: {
                                        block30: {
                                            block28: {
                                                r = null;
                                                cls2 = this.getIdentifier((OWLObject)ce);
                                                exact = null;
                                                min = null;
                                                max = null;
                                                allSome = null;
                                                allOnly = null;
                                                if (!(ce instanceof OWLObjectSomeValuesFrom)) break block28;
                                                OWLObjectSomeValuesFrom ristriction = (OWLObjectSomeValuesFrom)ce;
                                                r = this.getIdentifier((OWLObject)ristriction.getProperty());
                                                cls2 = this.getIdentifier((OWLObject)ristriction.getFiller());
                                                break block29;
                                            }
                                            if (!(ce instanceof OWLObjectExactCardinality)) break block30;
                                            card = (OWLObjectExactCardinality)ce;
                                            r = this.getIdentifier((OWLObject)card.getProperty());
                                            cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                            exact = card.getCardinality();
                                            break block29;
                                        }
                                        if (!(ce instanceof OWLObjectMinCardinality)) break block31;
                                        card = (OWLObjectMinCardinality)ce;
                                        r = this.getIdentifier((OWLObject)card.getProperty());
                                        cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                        min = card.getCardinality();
                                        break block29;
                                    }
                                    if (!(ce instanceof OWLObjectMaxCardinality)) break block32;
                                    card = (OWLObjectMaxCardinality)ce;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                    max = card.getCardinality();
                                    break block29;
                                }
                                if (!(ce instanceof OWLObjectAllValuesFrom)) break block33;
                                all = (OWLObjectAllValuesFrom)ce;
                                filler = (OWLClassExpression)all.getFiller();
                                if (!(filler instanceof OWLClass)) break block34;
                                r = this.getIdentifier((OWLObject)all.getProperty());
                                cls2 = this.getIdentifier((OWLObject)filler);
                                allOnly = Boolean.TRUE;
                                break block29;
                            }
                            if (!(filler instanceof OWLObjectComplementOf)) break block29;
                            OWLObjectComplementOf restriction = (OWLObjectComplementOf)filler;
                            r = this.getIdentifier((OWLObject)all.getProperty());
                            cls2 = this.getIdentifier((OWLObject)restriction.getOperand());
                            exact = 0;
                            break block29;
                        }
                        if (ce instanceof OWLObjectIntersectionOf && (operands = ((OWLObjectIntersectionOf)ce).getOperands()).size() == 2) {
                            for (OWLClassExpression operand : operands) {
                                OWLObjectAllValuesFrom all;
                                OWLObjectMinCardinality card;
                                if (operand instanceof OWLObjectMinCardinality) {
                                    card = (OWLObjectMinCardinality)operand;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                    min = card.getCardinality();
                                    continue;
                                }
                                if (operand instanceof OWLObjectMaxCardinality) {
                                    card = (OWLObjectMaxCardinality)operand;
                                    r = this.getIdentifier((OWLObject)card.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)card.getFiller());
                                    max = card.getCardinality();
                                    continue;
                                }
                                if (operand instanceof OWLObjectAllValuesFrom) {
                                    all = (OWLObjectAllValuesFrom)operand;
                                    r = this.getIdentifier((OWLObject)all.getProperty());
                                    cls2 = this.getIdentifier((OWLObject)all.getFiller());
                                    allOnly = Boolean.TRUE;
                                    continue;
                                }
                                if (!(operand instanceof OWLObjectSomeValuesFrom)) continue;
                                all = (OWLObjectSomeValuesFrom)operand;
                                r = this.getIdentifier((OWLObject)all.getProperty());
                                cls2 = this.getIdentifier((OWLObject)all.getFiller());
                                allSome = Boolean.TRUE;
                            }
                        }
                    }
                    if (cls2 != null) {
                        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag());
                        if (r != null) {
                            c.addValue(r);
                        }
                        c.addValue(cls2);
                        equivalenceAxiomClauses.add(c);
                        if (exact != null) {
                            c.addQualifierValue(new QualifierValue("cardinality", exact.toString()));
                        }
                        if (min != null) {
                            c.addQualifierValue(new QualifierValue("minCardinality", min.toString()));
                        }
                        if (max != null) {
                            c.addQualifierValue(new QualifierValue("maxCardinality", max.toString()));
                        }
                        if (allSome != null) {
                            c.addQualifierValue(new QualifierValue("all_some", allSome.toString()));
                        }
                        if (allOnly != null) {
                            c.addQualifierValue(new QualifierValue("all_only", allOnly.toString()));
                        }
                        this.addQualifiers(c, ax.getAnnotations());
                        continue;
                    }
                    if (f.getClauses(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF).size() > 0) {
                        this.error("The axiom is not translated (maximimum one IntersectionOf EquivalenceAxiom)", (OWLAxiom)ax);
                        continue;
                    }
                    isUntranslateable = true;
                    this.error((OWLAxiom)ax);
                }
                break block25;
            }
            isUntranslateable = true;
            this.error((OWLAxiom)ax);
        }
        if (!isUntranslateable) {
            for (Clause c : equivalenceAxiomClauses) {
                f.addClause(c);
            }
        }
    }

    protected void tr(OWLDisjointClassesAxiom ax) {
        String cls2;
        Set set = ax.getClassExpressions();
        if (set.size() != 2) {
            this.error("Expected two classes in a disjoin classes axiom.", (OWLAxiom)ax);
        }
        Iterator it = set.iterator();
        OWLClassExpression ce1 = (OWLClassExpression)it.next();
        OWLClassExpression ce2 = (OWLClassExpression)it.next();
        if (ce1.isBottomEntity() || ce1.isTopEntity() || ce2.isBottomEntity() || ce2.isTopEntity()) {
            this.error("Disjoint classes axiom using Top or Bottom entities are not supported.", (OWLAxiom)ax);
        }
        if ((cls2 = this.getIdentifier((OWLObject)ce2)) == null) {
            this.error((OWLAxiom)ax);
            return;
        }
        if (ce1.isAnonymous()) {
            this.error((OWLAxiom)ax);
            return;
        }
        OWLClass cls1 = ce1.asOWLClass();
        Frame f = this.getTermFrame(cls1);
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
        c.setValue(cls2);
        f.addClause(c);
        this.addQualifiers(c, ax.getAnnotations());
    }

    protected void tr(OWLDeclarationAxiom axiom) {
        OWLEntity entity = axiom.getEntity();
        if (entity.isBottomEntity() || entity.isTopEntity()) {
            return;
        }
        Set set = entity.getAnnotationAssertionAxioms(this.owlOntology);
        if (set.isEmpty()) {
            return;
        }
        Frame f = null;
        if (entity instanceof OWLClass) {
            f = this.getTermFrame(entity.asOWLClass());
        } else if (entity instanceof OWLObjectProperty) {
            f = this.getTypedefFrame((OWLEntity)entity.asOWLObjectProperty());
        } else if (entity instanceof OWLAnnotationProperty) {
            for (OWLAnnotationAssertionAxiom ax : set) {
                OWLAnnotationProperty prop = ax.getProperty();
                String tag = OWLAPIOwl2Obo.owlObjectToTag((OWLObject)prop);
                if (!OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag().equals(tag)) continue;
                f = this.getTypedefFrame(entity);
                break;
            }
        }
        if (f != null) {
            for (OWLAnnotationAssertionAxiom aanAx : set) {
                this.tr(aanAx, f);
            }
            this.add(f);
            return;
        }
    }

    public String getIdentifier(OWLObject obj) {
        try {
            return OWLAPIOwl2Obo.getIdentifierFromObject(obj, this.owlOntology);
        }
        catch (UntranslatableAxiomException e) {
            this.error(e.getMessage());
            return null;
        }
    }

    public static String getIdentifierFromObject(OWLObject obj, OWLOntology ont, String defaultValue) {
        String id = defaultValue;
        try {
            id = OWLAPIOwl2Obo.getIdentifierFromObject(obj, ont);
            if (id == null) {
                id = defaultValue;
            }
        }
        catch (UntranslatableAxiomException e) {
            LOG.log(Level.WARNING, e.getMessage());
        }
        return id;
    }

    public static String getIdentifierFromObject(OWLObject obj, OWLOntology ont) throws UntranslatableAxiomException {
        if (obj instanceof OWLObjectProperty || obj instanceof OWLAnnotationProperty) {
            OWLEntity entity = (OWLEntity)obj;
            Set axioms = entity.getAnnotationAssertionAxioms(ont);
            for (OWLAnnotationAssertionAxiom ax : axioms) {
                String propId = OWLAPIOwl2Obo.getIdentifierFromObject((OWLObject)ax.getProperty().getIRI(), ont);
                if (!propId.equals("shorthand")) continue;
                OWLAnnotationValue value = ax.getValue();
                if (value != null && value instanceof OWLLiteral) {
                    return ((OWLLiteral)value).getLiteral();
                }
                throw new UntranslatableAxiomException("Untranslatable axiom, expected literal value, but was: " + value + " in axiom: " + ax);
            }
        }
        if (obj instanceof OWLEntity) {
            return OWLAPIOwl2Obo.getIdentifier(((OWLEntity)obj).getIRI(), ont);
        }
        if (obj instanceof IRI) {
            return OWLAPIOwl2Obo.getIdentifier((IRI)obj, ont);
        }
        return null;
    }

    public static String getIdentifier(IRI iriId) {
        return OWLAPIOwl2Obo.getIdentifier(iriId, null);
    }

    protected String getIdentifierUsingBaseOntology(IRI iriId) {
        return OWLAPIOwl2Obo.getIdentifier(iriId, this.owlOntology);
    }

    public static String getIdentifier(IRI iriId, OWLOntology baseOntology) {
        if (iriId == null) {
            return null;
        }
        String iri = iriId.toString();
        int indexSlash = iri.lastIndexOf("/");
        String id = null;
        id = indexSlash > -1 ? iri.substring(indexSlash + 1) : iri;
        String[] s = id.split("#_");
        if (s.length > 1) {
            return s[0] + ":" + s[1];
        }
        s = id.split("#");
        if (s.length > 1) {
            String prefix = "";
            if ("owl".equals(s[0]) || "rdf".equals(s[0]) || "rdfs".equals(s[0])) {
                prefix = s[0] + ":";
            }
            return prefix + s[1];
        }
        s = id.split("_");
        if (s.length == 2 && !id.contains("#") && !s[1].contains("_")) {
            try {
                String localId = URLDecoder.decode(s[1], "UTF-8");
                return s[0] + ":" + localId;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 not supported, JRE corrupted?", e);
            }
        }
        if (s.length > 2 && !id.contains("#") && s[s.length - 1].replaceAll("[0-9]", "").length() == 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < s.length; ++i) {
                if (i > 0) {
                    if (i == s.length - 1) {
                        sb.append(":");
                    } else {
                        sb.append("_");
                    }
                }
                sb.append(s[i]);
            }
            return sb.toString();
        }
        return iri;
    }

    public static String owlObjectToTag(OWLObject obj) {
        IRI iriObj = null;
        if (obj instanceof OWLNamedObject) {
            iriObj = ((OWLNamedObject)obj).getIRI();
        } else if (obj instanceof IRI) {
            iriObj = (IRI)obj;
        }
        if (iriObj == null) {
            return null;
        }
        String iri = iriObj.toString();
        String tag = annotationPropertyMap.get(iri);
        if (tag == null) {
            String prefix;
            if (iri.startsWith("http://purl.obolibrary.org/obo/IAO_")) {
                String legacyId = iri.replace("http://purl.obolibrary.org/obo/", "");
                if (legacyId.equals("IAO_xref")) {
                    return OBOFormatConstants.OboFormatTag.TAG_XREF.getTag();
                }
                if (legacyId.equals("IAO_id")) {
                    return OBOFormatConstants.OboFormatTag.TAG_ID.getTag();
                }
                if (legacyId.equals("IAO_namespace")) {
                    return OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag();
                }
            }
            if (iri.startsWith(prefix = "http://www.geneontology.org/formats/oboInOwl#")) {
                tag = iri.substring(prefix.length());
            }
        }
        return tag;
    }

    protected Frame getTermFrame(OWLClass entity) {
        String id = this.getIdentifierUsingBaseOntology(entity.getIRI());
        Frame f = this.obodoc.getTermFrame(id);
        if (f == null) {
            f = new Frame(Frame.FrameType.TERM);
            f.setId(id);
            f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ID, id));
            this.add(f);
        }
        return f;
    }

    protected Frame getTypedefFrame(OWLEntity entity) {
        String id = this.getIdentifier((OWLObject)entity);
        Frame f = this.obodoc.getTypedefFrame(id);
        if (f == null) {
            f = new Frame(Frame.FrameType.TYPEDEF);
            f.setId(id);
            f.addClause(new Clause(OBOFormatConstants.OboFormatTag.TAG_ID, id));
            this.add(f);
        }
        return f;
    }

    protected void tr(OWLClassAssertionAxiom ax) {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void tr(OWLSubClassOfAxiom ax) {
        String fillerId;
        OWLClassExpression filler;
        void var2_4;
        Clause c;
        Set xs;
        OWLClassExpression oWLClassExpression = ax.getSubClass();
        OWLClassExpression sup = ax.getSuperClass();
        HashSet<QualifierValue> qvs = new HashSet<QualifierValue>();
        if (oWLClassExpression.isOWLNothing() || oWLClassExpression.isTopEntity() || sup.isTopEntity() || sup.isOWLNothing()) {
            this.error("Assertions using owl:Thing or owl:Nothing are not translateable OBO", (OWLAxiom)ax);
            return;
        }
        if (oWLClassExpression instanceof OWLObjectIntersectionOf && (xs = ((OWLObjectIntersectionOf)oWLClassExpression).getOperands()).size() == 2) {
            c = null;
            OWLObjectSomeValuesFrom r = null;
            OWLObjectProperty p = null;
            OWLClass filler2 = null;
            for (OWLClassExpression x : xs) {
                if (x instanceof OWLClass) {
                    c = (OWLClass)x;
                }
                if (!(x instanceof OWLObjectSomeValuesFrom) || !((r = (OWLObjectSomeValuesFrom)x).getProperty() instanceof OWLObjectProperty) || !(r.getFiller() instanceof OWLClass)) continue;
                p = (OWLObjectProperty)r.getProperty();
                filler2 = (OWLClass)r.getFiller();
            }
            if (c != null && p != null && filler2 != null) {
                Clause clause = c;
                qvs.add(new QualifierValue("gci_relation", this.getIdentifier((OWLObject)p)));
                qvs.add(new QualifierValue("gci_filler", this.getIdentifier((OWLObject)filler2)));
            }
        }
        if (!(var2_4 instanceof OWLClass)) {
            this.error((OWLAxiom)ax);
            return;
        }
        Frame f = this.getTermFrame((OWLClass)var2_4);
        if (sup instanceof OWLClass) {
            c = new Clause(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag());
            c.setValue(this.getIdentifier((OWLObject)sup));
            c.setQualifierValues(qvs);
            f.addClause(c);
            this.addQualifiers(c, ax.getAnnotations());
            return;
        }
        if (sup instanceof OWLQuantifiedObjectRestriction) {
            OWLQuantifiedObjectRestriction r = (OWLQuantifiedObjectRestriction)sup;
            filler = (OWLClassExpression)r.getFiller();
            if (filler.isBottomEntity() || filler.isTopEntity()) {
                this.error("Assertions using owl:Thing or owl:Nothing are not translateable OBO", (OWLAxiom)ax);
                return;
            }
            fillerId = this.getIdentifier((OWLObject)filler);
            if (fillerId == null) {
                this.error((OWLAxiom)ax);
                return;
            }
            f.addClause(this.createRelationshipClauseWithRestrictions(r, fillerId, qvs, ax));
            return;
        }
        if (sup instanceof OWLObjectCardinalityRestriction) {
            OWLObjectCardinalityRestriction cardinality = (OWLObjectCardinalityRestriction)sup;
            filler = (OWLClassExpression)cardinality.getFiller();
            if (filler.isBottomEntity() || filler.isTopEntity()) {
                this.error("Assertions using owl:Thing or owl:Nothing are not translateable OBO", (OWLAxiom)ax);
                return;
            }
            fillerId = this.getIdentifier((OWLObject)filler);
            if (fillerId == null) {
                this.error((OWLAxiom)ax);
                return;
            }
            f.addClause(this.createRelationshipClauseWithCardinality(cardinality, fillerId, qvs, ax));
            return;
        }
        if (!(sup instanceof OWLObjectIntersectionOf)) {
            this.error((OWLAxiom)ax);
            return;
        }
        OWLObjectIntersectionOf i = (OWLObjectIntersectionOf)sup;
        List<Clause> clauses = new ArrayList<Clause>();
        for (OWLClassExpression operand : i.getOperands()) {
            String fillerId2;
            OWLClassExpression filler3;
            OWLQuantifiedObjectRestriction restriction;
            if (operand instanceof OWLQuantifiedObjectRestriction) {
                restriction = (OWLQuantifiedObjectRestriction)operand;
                filler3 = (OWLClassExpression)restriction.getFiller();
                if (filler3.isBottomEntity() || filler3.isTopEntity()) {
                    this.error("Assertions using owl:Thing or owl:Nothing are not translateable OBO", (OWLAxiom)ax);
                    return;
                }
                fillerId2 = this.getIdentifier((OWLObject)filler3);
                if (fillerId2 == null) {
                    this.error((OWLAxiom)ax);
                    return;
                }
                clauses.add(this.createRelationshipClauseWithRestrictions(restriction, fillerId2, new HashSet<QualifierValue>(qvs), ax));
                continue;
            }
            if (!(operand instanceof OWLObjectCardinalityRestriction)) {
                this.error((OWLAxiom)ax);
                return;
            }
            restriction = (OWLObjectCardinalityRestriction)operand;
            filler3 = (OWLClassExpression)restriction.getFiller();
            if (filler3.isBottomEntity() || filler3.isTopEntity()) {
                this.error("Assertions using owl:Thing or owl:Nothing are not translateable OBO", (OWLAxiom)ax);
                return;
            }
            fillerId2 = this.getIdentifier((OWLObject)filler3);
            if (fillerId2 == null) {
                this.error((OWLAxiom)ax);
                return;
            }
            clauses.add(this.createRelationshipClauseWithCardinality((OWLObjectCardinalityRestriction)restriction, fillerId2, new HashSet<QualifierValue>(qvs), ax));
        }
        if (clauses.isEmpty()) {
            this.error((OWLAxiom)ax);
            return;
        }
        clauses = OWLAPIOwl2Obo.normalizeRelationshipClauses(clauses);
        Iterator<Object> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            f.addClause(clause);
        }
    }

    protected Clause createRelationshipClauseWithRestrictions(OWLQuantifiedObjectRestriction r, String fillerId, Set<QualifierValue> qvs, OWLSubClassOfAxiom ax) {
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        c.addValue(this.getIdentifier((OWLObject)r.getProperty()));
        c.addValue(fillerId);
        c.setQualifierValues(qvs);
        this.addQualifiers(c, ax.getAnnotations());
        return c;
    }

    protected Clause createRelationshipClauseWithCardinality(OWLObjectCardinalityRestriction restriction, String fillerId, Set<QualifierValue> qvs, OWLSubClassOfAxiom ax) {
        Clause c = new Clause(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        c.addValue(this.getIdentifier((OWLObject)restriction.getProperty()));
        c.addValue(fillerId);
        c.setQualifierValues(qvs);
        String q = "cardinality";
        if (restriction instanceof OWLObjectMinCardinality) {
            q = "minCardinality";
        } else if (restriction instanceof OWLObjectMaxCardinality) {
            q = "maxCardinality";
        }
        c.addQualifierValue(new QualifierValue(q, Integer.toString(restriction.getCardinality())));
        this.addQualifiers(c, ax.getAnnotations());
        return c;
    }

    public static List<Clause> normalizeRelationshipClauses(List<Clause> clauses) {
        ArrayList<Clause> normalized = new ArrayList<Clause>();
        while (!clauses.isEmpty()) {
            Clause target = clauses.remove(0);
            List<Clause> similar = OWLAPIOwl2Obo.findSimilarClauses(clauses, target);
            normalized.add(target);
            OWLAPIOwl2Obo.mergeSimilarIntoTarget(target, similar);
        }
        return normalized;
    }

    static List<Clause> findSimilarClauses(List<Clause> clauses, Clause target) {
        String targetTag = target.getTag();
        Object targetValue = target.getValue();
        Object targetValue2 = target.getValue2();
        ArrayList<Clause> similar = new ArrayList<Clause>();
        Iterator<Clause> iterator = clauses.iterator();
        while (iterator.hasNext()) {
            Clause current = iterator.next();
            Object currentValue = current.getValue();
            Object currentValue2 = current.getValue2();
            if (!targetTag.equals(current.getTag()) || !targetValue.equals(currentValue)) continue;
            if (targetValue2 == null) {
                if (currentValue2 != null) continue;
                similar.add(current);
                iterator.remove();
                continue;
            }
            if (!targetValue2.equals(currentValue2)) continue;
            similar.add(current);
            iterator.remove();
        }
        return similar;
    }

    static void mergeSimilarIntoTarget(Clause target, List<Clause> similar) {
        if (similar.isEmpty()) {
            return;
        }
        Collection<QualifierValue> targetQVs = target.getQualifierValues();
        for (Clause current : similar) {
            Collection<QualifierValue> newQVs = current.getQualifierValues();
            for (QualifierValue newQV : newQVs) {
                String newQualifier = newQV.getQualifier();
                if ("minCardinality".equals(newQualifier) || "maxCardinality".equals(newQualifier)) {
                    QualifierValue match = OWLAPIOwl2Obo.findMatchingQualifierValue(newQV, targetQVs);
                    if (match != null) {
                        OWLAPIOwl2Obo.mergeQualifierValues(match, newQV);
                        continue;
                    }
                    target.addQualifierValue(newQV);
                    continue;
                }
                target.addQualifierValue(newQV);
            }
        }
    }

    static QualifierValue findMatchingQualifierValue(QualifierValue query, Collection<QualifierValue> list) {
        String queryQualifier = query.getQualifier();
        for (QualifierValue qv : list) {
            if (!queryQualifier.equals(qv.getQualifier())) continue;
            return qv;
        }
        return null;
    }

    static void mergeQualifierValues(QualifierValue target, QualifierValue newQV) {
        if (!target.getValue().equals(newQV.getValue())) {
            if ("minCardinality".equals(target.getQualifier())) {
                int currentValue = Integer.parseInt(target.getValue().toString());
                int newValue = Integer.parseInt(newQV.getValue().toString());
                int mergedValue = Math.min(currentValue, newValue);
                target.setValue(Integer.toString(mergedValue));
            } else if ("maxCardinality".equals(target.getQualifier())) {
                int currentValue = Integer.parseInt(target.getValue().toString());
                int newValue = Integer.parseInt(newQV.getValue().toString());
                int mergedValue = Math.max(currentValue, newValue);
                target.setValue(Integer.toString(mergedValue));
            }
        }
    }

    protected void error(String message, OWLAxiom ax) {
        this.untranslatableAxioms.add(ax);
        this.error(message + ax);
    }

    protected void error(OWLAxiom ax) {
        this.untranslatableAxioms.add(ax);
        this.error("the axiom is not translated : " + ax);
    }

    protected void error(String message) {
        LOG.log(Level.WARNING, message);
        if (this.strictConversion) {
            throw new RuntimeException("The conversion is halted: " + message);
        }
    }

    public static class UntranslatableAxiomException
    extends Exception {
        private static final long serialVersionUID = 4674805484349471665L;

        public UntranslatableAxiomException(String message, Throwable cause) {
            super(message, cause);
        }

        public UntranslatableAxiomException(String message) {
            super(message);
        }
    }
}

