/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLIndividualVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.owl.owlapi.ImplUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLIndividualImpl;

public class OWLNamedIndividualImpl
extends OWLIndividualImpl
implements OWLNamedIndividual {
    private static final long serialVersionUID = 30406L;
    private final IRI iri;

    public OWLNamedIndividualImpl(IRI iri) {
        this.iri = iri;
    }

    public boolean isNamed() {
        return true;
    }

    public EntityType<?> getEntityType() {
        return EntityType.NAMED_INDIVIDUAL;
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType) {
        return OWLNamedIndividualImpl.getOWLEntity(entityType, this.getIRI());
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public boolean isOWLNamedIndividual() {
        return true;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isAnonymous() {
        return false;
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        return this;
    }

    public OWLAnonymousIndividual asOWLAnonymousIndividual() {
        throw new OWLRuntimeException("Not an anonymous individual");
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLNamedIndividual)) {
                return false;
            }
            IRI otherIRI = ((OWLNamedIndividual)obj).getIRI();
            return otherIRI.equals((Object)this.iri);
        }
        return false;
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return ImplUtils.getAnnotations((OWLEntity)this, annotationProperty, Collections.singleton(ontology));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology) {
        return ontology.getReferencingAxioms((OWLEntity)this);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms((OWLEntity)this, includeImports);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLNamedIndividual other = (OWLNamedIndividual)object;
        return this.iri.compareTo((OWLObject)other.getIRI());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public void accept(OWLIndividualVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLIndividualVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }
}

