/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.AbstractEntityRegistrationManager;
import uk.ac.manchester.cs.owl.owlapi.AbstractInternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;

public class InternalsImpl
extends AbstractInternalsImpl {
    private static final long serialVersionUID = 30406L;
    protected final SetPointer<OWLImportsDeclaration> importsDeclarations = this.buildSet();
    protected final SetPointer<OWLAnnotation> ontologyAnnotations = this.buildSet();
    protected final SetPointer<OWLClassAxiom> generalClassAxioms = this.buildSet();
    protected final SetPointer<OWLSubPropertyChainOfAxiom> propertyChainSubPropertyAxioms = this.buildSet();
    protected final MapPointer<AxiomType<?>, OWLAxiom> axiomsByType = this.build();
    protected final MapPointer<OWLClass, OWLAxiom> owlClassReferences = this.build();
    protected final MapPointer<OWLObjectProperty, OWLAxiom> owlObjectPropertyReferences = this.build();
    protected final MapPointer<OWLDataProperty, OWLAxiom> owlDataPropertyReferences = this.build();
    protected final MapPointer<OWLNamedIndividual, OWLAxiom> owlIndividualReferences = this.build();
    protected final MapPointer<OWLAnonymousIndividual, OWLAxiom> owlAnonymousIndividualReferences = this.build();
    protected final MapPointer<OWLDatatype, OWLAxiom> owlDatatypeReferences = this.build();
    protected final MapPointer<OWLAnnotationProperty, OWLAxiom> owlAnnotationPropertyReferences = this.build();
    protected final MapPointer<OWLEntity, OWLDeclarationAxiom> declarationsByEntity = this.build();
    private final AddAxiomVisitor addChangeVisitor = new AddAxiomVisitor();
    private final RemoveAxiomVisitor removeChangeVisitor = new RemoveAxiomVisitor();

    protected <K> SetPointer<K> buildSet() {
        return new SetPointer(CollectionFactory.createSyncSet());
    }

    @Override
    public <K, V extends OWLAxiom> Set<K> getKeyset(Internals.Pointer<K, V> pointer) {
        MapPointer mapPointer = (MapPointer)pointer;
        mapPointer.init();
        return mapPointer.keySet();
    }

    @Override
    public <K, V extends OWLAxiom> Set<V> getValues(Internals.Pointer<K, V> pointer, K key) {
        MapPointer mapPointer = (MapPointer)pointer;
        mapPointer.init();
        return mapPointer.getValues(key);
    }

    @Override
    public <K, V extends OWLAxiom> boolean hasValues(Internals.Pointer<K, V> pointer, K key) {
        MapPointer mapPointer = (MapPointer)pointer;
        mapPointer.init();
        return mapPointer.hasValues(key);
    }

    @Override
    public <K, V extends OWLAxiom> boolean remove(Internals.Pointer<K, V> pointer, K k, V v) {
        MapPointer mapPointer = (MapPointer)pointer;
        if (!mapPointer.isInitialized()) {
            return false;
        }
        return mapPointer.remove(k, v);
    }

    @Override
    public boolean addAxiom(final OWLAxiom axiom) {
        if (this.add(this.getAxiomsByType(), axiom.getAxiomType(), axiom)) {
            axiom.accept((OWLAxiomVisitor)this.addChangeVisitor);
            axiom.accept((OWLObjectVisitor)new AbstractEntityRegistrationManager(){

                public void visit(OWLClass owlClass) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlClassReferences(), owlClass, axiom);
                }

                public void visit(OWLObjectProperty property) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlObjectPropertyReferences(), property, axiom);
                }

                public void visit(OWLDataProperty property) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlDataPropertyReferences(), property, axiom);
                }

                public void visit(OWLNamedIndividual owlIndividual) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlIndividualReferences(), owlIndividual, axiom);
                }

                public void visit(OWLAnnotationProperty property) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlAnnotationPropertyReferences(), property, axiom);
                }

                public void visit(OWLDatatype datatype) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlDatatypeReferences(), datatype, axiom);
                }

                public void visit(OWLAnonymousIndividual individual) {
                    InternalsImpl.this.add(InternalsImpl.this.getOwlAnonymousIndividualReferences(), individual, axiom);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAxiom(final OWLAxiom axiom) {
        if (this.remove(this.getAxiomsByType(), axiom.getAxiomType(), axiom)) {
            axiom.accept((OWLAxiomVisitor)this.removeChangeVisitor);
            AbstractEntityRegistrationManager referenceRemover = new AbstractEntityRegistrationManager(){

                public void visit(OWLClass owlClass) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlClassReferences(), owlClass, axiom);
                }

                public void visit(OWLObjectProperty property) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlObjectPropertyReferences(), property, axiom);
                }

                public void visit(OWLDataProperty property) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlDataPropertyReferences(), property, axiom);
                }

                public void visit(OWLNamedIndividual owlIndividual) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlIndividualReferences(), owlIndividual, axiom);
                }

                public void visit(OWLAnnotationProperty property) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlAnnotationPropertyReferences(), property, axiom);
                }

                public void visit(OWLDatatype datatype) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlDatatypeReferences(), datatype, axiom);
                }

                public void visit(OWLAnonymousIndividual individual) {
                    InternalsImpl.this.remove(InternalsImpl.this.getOwlAnonymousIndividualReferences(), individual, axiom);
                }
            };
            axiom.accept((OWLObjectVisitor)referenceRemover);
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeclared(OWLDeclarationAxiom ax) {
        return this.declarationsByEntity.containsKey(ax.getEntity());
    }

    @Override
    public boolean isEmpty() {
        return this.axiomsByType.size() == 0 && this.ontologyAnnotations.isEmpty();
    }

    @Override
    public <T extends OWLAxiom, K> Set<T> filterAxioms(OWLAxiomSearchFilter<T, K> filter, K key) {
        Set toReturn = CollectionFactory.createSet();
        for (OWLAxiom t : this.getValues(this.getAxiomsByType(), filter.getAxiomType())) {
            if (!filter.pass(t, key)) continue;
            toReturn.add(t);
        }
        return toReturn;
    }

    @Override
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.importsDeclarations.copy();
    }

    @Override
    public boolean addImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        if (this.importsDeclarations.contains(importDeclaration)) {
            return false;
        }
        this.importsDeclarations.add(importDeclaration);
        return true;
    }

    @Override
    public boolean removeImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        if (!this.importsDeclarations.contains(importDeclaration)) {
            return false;
        }
        this.importsDeclarations.remove(importDeclaration);
        return true;
    }

    @Override
    public Set<OWLAnnotation> getOntologyAnnotations() {
        return this.ontologyAnnotations.copy();
    }

    @Override
    public boolean addOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.add(ann);
    }

    @Override
    public boolean removeOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.remove(ann);
    }

    @Override
    public <K, V extends OWLAxiom> boolean contains(Internals.Pointer<K, V> p, K k) {
        return ((MapPointer)p).containsKey(k);
    }

    @Override
    public <K, V extends OWLAxiom> boolean contains(Internals.Pointer<K, V> p, K k, V v) {
        return ((MapPointer)p).contains(k, v);
    }

    @Override
    public int getAxiomCount() {
        return this.axiomsByType.size();
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return this.axiomsByType.getAllValues();
    }

    @Override
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        if (!this.axiomsByType.isInitialized()) {
            return 0;
        }
        Set<OWLAxiom> collection = this.axiomsByType.getValues(axiomType);
        if (collection.isEmpty()) {
            return 0;
        }
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>(collection);
        return axioms.size();
    }

    @Override
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        Set axioms = CollectionFactory.createSet();
        for (AxiomType type : AxiomType.AXIOM_TYPES) {
            Set<OWLAxiom> axiomSet;
            if (!type.isLogical() || (axiomSet = this.axiomsByType.getValues(type)) == null) continue;
            for (OWLAxiom ax : axiomSet) {
                axioms.add((OWLLogicalAxiom)ax);
            }
        }
        return axioms;
    }

    @Override
    public int getLogicalAxiomCount() {
        return this.getLogicalAxioms().size();
    }

    @Override
    public <K, V extends OWLAxiom> boolean add(Internals.Pointer<K, V> p, K k, V v) {
        MapPointer map = (MapPointer)p;
        if (!map.isInitialized()) {
            return false;
        }
        return map.put(k, v);
    }

    @Override
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.generalClassAxioms.copy();
    }

    @Override
    public void addGeneralClassAxioms(OWLClassAxiom ax) {
        this.generalClassAxioms.add(ax);
    }

    @Override
    public void removeGeneralClassAxioms(OWLClassAxiom ax) {
        this.generalClassAxioms.remove(ax);
    }

    @Override
    public void addPropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        this.propertyChainSubPropertyAxioms.add(ax);
    }

    @Override
    public void removePropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        this.propertyChainSubPropertyAxioms.remove(ax);
    }

    public MapPointer<OWLClass, OWLAxiom> getOwlClassReferences() {
        return this.owlClassReferences;
    }

    public MapPointer<OWLObjectProperty, OWLAxiom> getOwlObjectPropertyReferences() {
        return this.owlObjectPropertyReferences;
    }

    public MapPointer<OWLDataProperty, OWLAxiom> getOwlDataPropertyReferences() {
        return this.owlDataPropertyReferences;
    }

    public MapPointer<OWLNamedIndividual, OWLAxiom> getOwlIndividualReferences() {
        return this.owlIndividualReferences;
    }

    public MapPointer<OWLAnonymousIndividual, OWLAxiom> getOwlAnonymousIndividualReferences() {
        return this.owlAnonymousIndividualReferences;
    }

    public MapPointer<OWLDatatype, OWLAxiom> getOwlDatatypeReferences() {
        return this.owlDatatypeReferences;
    }

    public MapPointer<OWLAnnotationProperty, OWLAxiom> getOwlAnnotationPropertyReferences() {
        return this.owlAnnotationPropertyReferences;
    }

    public MapPointer<OWLEntity, OWLDeclarationAxiom> getDeclarationsByEntity() {
        return this.declarationsByEntity;
    }

    public MapPointer<AxiomType<?>, OWLAxiom> getAxiomsByType() {
        return this.axiomsByType;
    }

    class RemoveAxiomVisitor
    implements OWLAxiomVisitor,
    Serializable {
        private static final long serialVersionUID = 30406L;

        RemoveAxiomVisitor() {
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                InternalsImpl.this.remove(InternalsImpl.this.getSubClassAxiomsByLHS(), subClass, axiom);
                InternalsImpl.this.remove(InternalsImpl.this.getClassAxiomsByClass(), subClass, axiom);
            } else {
                InternalsImpl.this.removeGeneralClassAxioms((OWLClassAxiom)axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                InternalsImpl.this.remove(InternalsImpl.this.getSubClassAxiomsByRHS(), axiom.getSuperClass().asOWLClass(), axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getNegativeObjectPropertyAssertionAxiomsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getAsymmetricPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getReflexivePropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLClass cls = (OWLClass)desc;
                InternalsImpl.this.remove(InternalsImpl.this.getDisjointClassesAxiomsByClass(), cls, axiom);
                InternalsImpl.this.remove(InternalsImpl.this.getClassAxiomsByClass(), cls, axiom);
                allAnon = false;
            }
            if (allAnon) {
                InternalsImpl.this.removeGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getDataPropertyDomainAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (axiom.getProperty() instanceof OWLObjectProperty) {
                InternalsImpl.this.remove(InternalsImpl.this.getObjectPropertyDomainAxiomsByProperty(), axiom.getProperty(), axiom);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.remove(InternalsImpl.this.getEquivalentObjectPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getInversePropertyAxiomsByProperty(), axiom.getFirstProperty(), axiom);
            InternalsImpl.this.remove(InternalsImpl.this.getInversePropertyAxiomsByProperty(), axiom.getSecondProperty(), axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getNegativeDataPropertyAssertionAxiomsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                InternalsImpl.this.remove(InternalsImpl.this.getDifferentIndividualsAxiomsByIndividual(), ind, axiom);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.remove(InternalsImpl.this.getDisjointDataPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.remove(InternalsImpl.this.getDisjointObjectPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getObjectPropertyRangeAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getObjectPropertyAssertionsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getFunctionalObjectPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getObjectSubPropertyAxiomsByLHS(), axiom.getSubProperty(), axiom);
            InternalsImpl.this.remove(InternalsImpl.this.getObjectSubPropertyAxiomsByRHS(), axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getDisjointUnionAxiomsByClass(), axiom.getOWLClass(), axiom);
            InternalsImpl.this.remove(InternalsImpl.this.getClassAxiomsByClass(), axiom.getOWLClass(), axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getDeclarationsByEntity(), axiom.getEntity(), axiom);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getAnnotationAssertionAxiomsBySubject(), axiom.getSubject(), axiom);
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                InternalsImpl.this.remove(InternalsImpl.this.getHasKeyAxiomsByClass(), axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getSymmetricPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getDataPropertyRangeAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getFunctionalDataPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.remove(InternalsImpl.this.getEquivalentDataPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getClassAssertionAxiomsByIndividual(), axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                InternalsImpl.this.remove(InternalsImpl.this.getClassAssertionAxiomsByClass(), axiom.getClassExpression(), axiom);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                InternalsImpl.this.remove(InternalsImpl.this.getEquivalentClassesAxiomsByClass(), (OWLClass)desc, axiom);
                InternalsImpl.this.remove(InternalsImpl.this.getClassAxiomsByClass(), (OWLClass)desc, axiom);
                allAnon = false;
            }
            if (allAnon) {
                InternalsImpl.this.removeGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getDataPropertyAssertionsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getTransitivePropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getIrreflexivePropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getDataSubPropertyAxiomsByLHS(), axiom.getSubProperty(), axiom);
            InternalsImpl.this.remove(InternalsImpl.this.getDataSubPropertyAxiomsByRHS(), axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            InternalsImpl.this.remove(InternalsImpl.this.getInverseFunctionalPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                InternalsImpl.this.remove(InternalsImpl.this.getSameIndividualsAxiomsByIndividual(), ind, axiom);
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            InternalsImpl.this.removePropertyChainSubPropertyAxioms(axiom);
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }
    }

    class AddAxiomVisitor
    implements OWLAxiomVisitor,
    Serializable {
        private static final long serialVersionUID = 30406L;

        AddAxiomVisitor() {
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                InternalsImpl.this.add(InternalsImpl.this.getSubClassAxiomsByLHS(), subClass, axiom);
                InternalsImpl.this.add(InternalsImpl.this.getClassAxiomsByClass(), subClass, axiom);
            } else {
                InternalsImpl.this.addGeneralClassAxioms((OWLClassAxiom)axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                InternalsImpl.this.add(InternalsImpl.this.getSubClassAxiomsByRHS(), (OWLClass)axiom.getSuperClass(), axiom);
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getNegativeObjectPropertyAssertionAxiomsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getAsymmetricPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getReflexivePropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLClass cls = (OWLClass)desc;
                InternalsImpl.this.add(InternalsImpl.this.getDisjointClassesAxiomsByClass(), cls, axiom);
                InternalsImpl.this.add(InternalsImpl.this.getClassAxiomsByClass(), cls, axiom);
                allAnon = false;
            }
            if (allAnon) {
                InternalsImpl.this.addGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getDataPropertyDomainAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (axiom.getProperty() instanceof OWLObjectProperty) {
                InternalsImpl.this.add(InternalsImpl.this.getObjectPropertyDomainAxiomsByProperty(), axiom.getProperty(), axiom);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.add(InternalsImpl.this.getEquivalentObjectPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getInversePropertyAxiomsByProperty(), axiom.getFirstProperty(), axiom);
            InternalsImpl.this.add(InternalsImpl.this.getInversePropertyAxiomsByProperty(), axiom.getSecondProperty(), axiom);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getNegativeDataPropertyAssertionAxiomsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                InternalsImpl.this.add(InternalsImpl.this.getDifferentIndividualsAxiomsByIndividual(), ind, axiom);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.add(InternalsImpl.this.getDisjointDataPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.add(InternalsImpl.this.getDisjointObjectPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getObjectPropertyRangeAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getObjectPropertyAssertionsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getFunctionalObjectPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getObjectSubPropertyAxiomsByLHS(), axiom.getSubProperty(), axiom);
            InternalsImpl.this.add(InternalsImpl.this.getObjectSubPropertyAxiomsByRHS(), axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getDisjointUnionAxiomsByClass(), axiom.getOWLClass(), axiom);
            InternalsImpl.this.add(InternalsImpl.this.getClassAxiomsByClass(), axiom.getOWLClass(), axiom);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getDeclarationsByEntity(), axiom.getEntity(), axiom);
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getAnnotationAssertionAxiomsBySubject(), axiom.getSubject(), axiom);
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                InternalsImpl.this.add(InternalsImpl.this.getHasKeyAxiomsByClass(), axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getSymmetricPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getDataPropertyRangeAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getFunctionalDataPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                InternalsImpl.this.add(InternalsImpl.this.getEquivalentDataPropertyAxiomsByProperty(), prop, axiom);
            }
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getClassAssertionAxiomsByIndividual(), axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                InternalsImpl.this.add(InternalsImpl.this.getClassAssertionAxiomsByClass(), axiom.getClassExpression(), axiom);
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                InternalsImpl.this.add(InternalsImpl.this.getEquivalentClassesAxiomsByClass(), (OWLClass)desc, axiom);
                InternalsImpl.this.add(InternalsImpl.this.getClassAxiomsByClass(), (OWLClass)desc, axiom);
                allAnon = false;
            }
            if (allAnon) {
                InternalsImpl.this.addGeneralClassAxioms((OWLClassAxiom)axiom);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getDataPropertyAssertionsByIndividual(), axiom.getSubject(), axiom);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getTransitivePropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getIrreflexivePropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getDataSubPropertyAxiomsByLHS(), axiom.getSubProperty(), axiom);
            InternalsImpl.this.add(InternalsImpl.this.getDataSubPropertyAxiomsByRHS(), axiom.getSuperProperty(), axiom);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            InternalsImpl.this.add(InternalsImpl.this.getInverseFunctionalPropertyAxiomsByProperty(), axiom.getProperty(), axiom);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                InternalsImpl.this.add(InternalsImpl.this.getSameIndividualsAxiomsByIndividual(), ind, axiom);
            }
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            InternalsImpl.this.addPropertyChainSubPropertyAxioms(axiom);
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }
    }

    protected class SetPointer<K>
    implements Internals.SimplePointer<K>,
    Serializable {
        private static final long serialVersionUID = 30406L;
        private final Set<K> set;

        public SetPointer(Set<K> s) {
            this.set = s;
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Set<K> copy() {
            return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.set);
        }

        public boolean add(K k) {
            return this.set.add(k);
        }

        public boolean contains(K k) {
            return this.set.contains(k);
        }

        public boolean remove(K k) {
            return this.set.remove(k);
        }
    }
}

