/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasoner;

public class StructuralReasonerFactory
implements OWLReasonerFactory {
    public String getReasonerName() {
        return "Structural Reasoner";
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology) {
        return this.createNonBufferingReasoner(ontology, (OWLReasonerConfiguration)new SimpleConfiguration());
    }

    public OWLReasoner createReasoner(OWLOntology ontology) {
        return this.createReasoner(ontology, (OWLReasonerConfiguration)new SimpleConfiguration());
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new StructuralReasoner(ontology, config, BufferingMode.NON_BUFFERING);
    }

    public OWLReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new StructuralReasoner(ontology, config, BufferingMode.BUFFERING);
    }
}

