/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashMap;
import java.util.Map;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class QNameShortFormProvider
implements ShortFormProvider {
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();

    public QNameShortFormProvider() {
        this(new HashMap<String, String>());
    }

    public QNameShortFormProvider(Map<String, String> prefix2NamespaceMap) {
        for (Map.Entry<String, String> e : prefix2NamespaceMap.entrySet()) {
            int lastChar;
            String key = e.getKey();
            if (key.charAt(lastChar = key.length() - 1) == ':') {
                key = key.substring(0, lastChar);
            }
            this.namespaceUtil.setPrefix(e.getValue(), key);
        }
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        String prefix = this.namespaceUtil.getPrefix(entity.getIRI().getNamespace());
        return entity.getIRI().prefixedBy(prefix + ':');
    }

    @Override
    public void dispose() {
    }
}

