/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.semanticweb.owlapi.io.BOMSafeInputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;

public class ReaderDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    private final IRI documentIRI;
    private byte[] buffer;

    public ReaderDocumentSource(Reader reader) {
        this(reader, ReaderDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("reader:ontology" + ++counter);
    }

    public ReaderDocumentSource(Reader reader, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.fillBuffer(reader);
    }

    private void fillBuffer(Reader reader) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            int length = 100000;
            char[] tempBuffer = new char[100000];
            int read = 0;
            do {
                if ((read = reader.read(tempBuffer, 0, 100000)) <= 0) continue;
                ((Writer)writer).write(tempBuffer, 0, read);
            } while (read > 0);
            ((Writer)writer).flush();
            this.buffer = out.toByteArray();
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BOMSafeInputStream(new ByteArrayInputStream(this.buffer));
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }
}

