/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.debugging.OWLDebugger;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;

public abstract class AbstractOWLDebugger
implements OWLDebugger {
    private final OWLOntologyManager owlOntologyManager;
    private OWLOntology ontology;

    protected AbstractOWLDebugger(OWLOntologyManager owlOntologyManager, OWLOntology ontology) {
        this.owlOntologyManager = owlOntologyManager;
        this.ontology = ontology;
        this.mergeImportsClosure();
    }

    private void mergeImportsClosure() {
        OWLOntology originalOntology = this.ontology;
        try {
            this.ontology = this.owlOntologyManager.createOntology(IRI.create((String)"http://debugger.semanticweb.org/", (String)("ontolog" + System.nanoTime())));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(originalOntology)) {
            for (OWLAxiom ax : ont.getLogicalAxioms()) {
                changes.add(new AddAxiom(this.ontology, ax));
            }
        }
        this.owlOntologyManager.applyChanges(changes);
    }

    protected abstract OWLClassExpression getCurrentClass() throws OWLException;

    @Override
    public OWLOntology getOWLOntology() throws OWLException {
        return this.ontology;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    @Override
    public Set<Set<OWLAxiom>> getAllSOSForIncosistentClass(OWLClassExpression cls) throws OWLException {
        Set<OWLAxiom> firstMups = this.getSOSForIncosistentClass(cls);
        if (firstMups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Set<OWLAxiom>> allMups = new HashSet<Set<OWLAxiom>>();
        allMups.add(firstMups);
        HashSet<Set<OWLAxiom>> satPaths = new HashSet<Set<OWLAxiom>>();
        HashSet<OWLAxiom> currentPathContents = new HashSet<OWLAxiom>();
        this.constructHittingSetTree(firstMups, allMups, satPaths, currentPathContents);
        return allMups;
    }

    public void constructHittingSetTree(Set<OWLAxiom> mups, Set<Set<OWLAxiom>> allMups, Set<Set<OWLAxiom>> satPaths, Set<OWLAxiom> currentPathContents) throws OWLException {
        for (OWLAxiom axiom : mups) {
            this.owlOntologyManager.applyChanges(Arrays.asList(new RemoveAxiom(this.ontology, axiom)));
            currentPathContents.add(axiom);
            boolean earlyTermination = false;
            for (Set<OWLAxiom> satPath : satPaths) {
                if (!satPath.containsAll(currentPathContents)) continue;
                earlyTermination = true;
                break;
            }
            if (!earlyTermination) {
                Set<OWLAxiom> newMUPS = this.getSOSForIncosistentClass(this.getCurrentClass());
                if (!newMUPS.isEmpty()) {
                    if (!allMups.contains(newMUPS)) {
                        allMups.add(newMUPS);
                        this.constructHittingSetTree(newMUPS, allMups, satPaths, currentPathContents);
                    }
                } else {
                    satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
                }
            }
            currentPathContents.remove(axiom);
            this.owlOntologyManager.applyChanges(Arrays.asList(new AddAxiom(this.ontology, axiom)));
        }
    }
}

