/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class ConvertPropertyAssertionsToAnnotations
extends AbstractCompositeOntologyChange {
    private final Set<OWLOntology> ontologies;
    private List<OWLOntologyChange> changes;

    public ConvertPropertyAssertionsToAnnotations(OWLDataFactory dataFactory, Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.ontologies = ontologies;
        this.generateChanges();
    }

    private void generateChanges() {
        this.changes = new ArrayList<OWLOntologyChange>();
        HashSet individuals = new HashSet();
        for (OWLOntology ont : this.ontologies) {
            individuals.addAll(ont.getIndividualsInSignature());
        }
        HashSet<OWLDataProperty> convertedDataProperties = new HashSet<OWLDataProperty>();
        for (OWLNamedIndividual ind : individuals) {
            boolean punned = false;
            for (OWLOntology ont : this.ontologies) {
                if (!ont.containsClassInSignature(ind.getIRI())) continue;
                punned = true;
                break;
            }
            if (!punned) continue;
            for (OWLOntology ont : this.ontologies) {
                for (OWLDataPropertyAssertionAxiom ax : ont.getDataPropertyAssertionAxioms((OWLIndividual)ind)) {
                    if (((OWLDataPropertyExpression)ax.getProperty()).isAnonymous()) continue;
                    this.changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
                    OWLDataFactory df = this.getDataFactory();
                    OWLAnnotation anno = df.getOWLAnnotation(df.getOWLAnnotationProperty(((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty().getIRI()), (OWLAnnotationValue)ax.getObject());
                    OWLAnnotationAssertionAxiom annoAx = df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)ind.getIRI(), anno);
                    this.changes.add((OWLOntologyChange)new AddAxiom(ont, (OWLAxiom)annoAx));
                    convertedDataProperties.add((OWLDataProperty)ax.getProperty());
                }
            }
            for (OWLOntology ont : this.ontologies) {
                for (OWLDataPropertyAssertionAxiom ax : ont.getDeclarationAxioms((OWLEntity)ind)) {
                    this.changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
                }
                for (OWLDataPropertyAssertionAxiom ax : ont.getClassAssertionAxioms((OWLIndividual)ind)) {
                    this.changes.add((OWLOntologyChange)new RemoveAxiom(ont, (OWLAxiom)ax));
                }
            }
        }
        for (OWLDataProperty prop : convertedDataProperties) {
            for (OWLOntology ont : this.ontologies) {
                for (OWLAxiom ax : ont.getDeclarationAxioms((OWLEntity)prop)) {
                    this.changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
                }
                for (OWLAxiom ax : ont.getAxioms(prop)) {
                    this.changes.add((OWLOntologyChange)new RemoveAxiom(ont, ax));
                }
            }
        }
    }

    @Override
    public List<OWLOntologyChange> getChanges() {
        return this.changes;
    }
}

