/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.HashSet;
import java.util.Iterator;
import org.mindswap.pellet.utils.intset.AbstractIntSet;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class HashIntSet
extends AbstractIntSet
implements IntSet {
    private HashSet<Integer> ints = new HashSet();

    @Override
    public void add(int value) {
        if (value < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ints.add(value);
        this.added(value, value);
    }

    @Override
    public void addAll(IntSet values) {
        if (values instanceof HashIntSet) {
            this.ints.addAll(((HashIntSet)values).ints);
            if (!values.isEmpty()) {
                this.added(values.min(), values.max());
            }
        } else {
            super.addAll(values);
        }
    }

    @Override
    public boolean contains(int value) {
        return this.ints.contains(value);
    }

    @Override
    public IntSet copy() {
        HashIntSet copy = new HashIntSet();
        copy.addAll(this);
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private Iterator<Integer> base;
            {
                this.base = HashIntSet.this.ints.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public int next() {
                return this.base.next();
            }
        };
    }

    @Override
    public void remove(int value) {
        this.ints.remove(value);
        this.removed(value, value);
    }

    @Override
    public int size() {
        return this.ints.size();
    }
}

