/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.blocking.Blocking;
import org.mindswap.pellet.tableau.blocking.BlockingFactory;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.branch.GuessBranch;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.queue.QueueElement;
import org.mindswap.pellet.tableau.completion.rule.AllValuesRule;
import org.mindswap.pellet.tableau.completion.rule.ChooseRule;
import org.mindswap.pellet.tableau.completion.rule.DataCardinalityRule;
import org.mindswap.pellet.tableau.completion.rule.DataSatisfiabilityRule;
import org.mindswap.pellet.tableau.completion.rule.DisjunctionRule;
import org.mindswap.pellet.tableau.completion.rule.GuessRule;
import org.mindswap.pellet.tableau.completion.rule.MaxRule;
import org.mindswap.pellet.tableau.completion.rule.MinRule;
import org.mindswap.pellet.tableau.completion.rule.NominalRule;
import org.mindswap.pellet.tableau.completion.rule.SelfRule;
import org.mindswap.pellet.tableau.completion.rule.SimpleAllValuesRule;
import org.mindswap.pellet.tableau.completion.rule.SomeValuesRule;
import org.mindswap.pellet.tableau.completion.rule.TableauRule;
import org.mindswap.pellet.tableau.completion.rule.UnfoldingRule;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public abstract class CompletionStrategy {
    public static final Logger log = Logger.getLogger(CompletionStrategy.class.getName());
    protected ABox abox;
    protected TBox tbox;
    protected Blocking blocking;
    protected Timers timers;
    protected Timer completionTimer;
    private boolean merging = false;
    private boolean mergingAll = false;
    protected List<NodeMerge> mergeList;
    protected TableauRule unfoldingRule = new UnfoldingRule(this);
    protected TableauRule disjunctionRule = new DisjunctionRule(this);
    protected AllValuesRule allValuesRule = new AllValuesRule(this);
    protected TableauRule someValuesRule = new SomeValuesRule(this);
    protected TableauRule chooseRule = new ChooseRule(this);
    protected TableauRule minRule = new MinRule(this);
    protected MaxRule maxRule = new MaxRule(this);
    protected TableauRule selfRule = new SelfRule(this);
    protected TableauRule nominalRule = new NominalRule(this);
    protected TableauRule guessRule = new GuessRule(this);
    protected TableauRule dataSatRule = new DataSatisfiabilityRule(this);
    protected TableauRule dataCardRule = new DataCardinalityRule(this);
    protected List<TableauRule> tableauRules;

    public CompletionStrategy(ABox abox) {
        this.abox = abox;
        this.tbox = abox.getTBox();
        this.timers = abox.getKB().timers;
        this.completionTimer = this.timers.getTimer("complete");
    }

    public ABox getABox() {
        return this.abox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public Blocking getBlocking() {
        return this.blocking;
    }

    public void checkTimer() {
        this.completionTimer.check();
    }

    public Iterator<Individual> getInitializeIterator() {
        return new IndividualIterator(this.abox);
    }

    protected void configureTableauRules(Expressivity expr) {
        if (!PelletOptions.USE_COMPLETION_STRATEGY) {
            this.addAllRules();
            return;
        }
        boolean fullDatatypeReasoning = PelletOptions.USE_FULL_DATATYPE_REASONING && (expr.hasUserDefinedDatatype() || expr.hasCardinalityD() || expr.hasKeys());
        this.tableauRules = new ArrayList<TableauRule>();
        if (!PelletOptions.USE_PSEUDO_NOMINALS && expr.hasNominal() || this.implicitNominals()) {
            this.tableauRules.add(this.nominalRule);
            if (expr.hasCardinalityQ()) {
                this.tableauRules.add(this.guessRule);
            }
        }
        if (expr.hasCardinalityQ() || expr.hasCardinalityD()) {
            this.tableauRules.add(this.chooseRule);
        }
        this.tableauRules.add(this.maxRule);
        if (fullDatatypeReasoning) {
            this.tableauRules.add(this.dataCardRule);
        }
        this.tableauRules.add(this.dataSatRule);
        this.tableauRules.add(this.unfoldingRule);
        this.tableauRules.add(this.disjunctionRule);
        this.tableauRules.add(this.someValuesRule);
        this.tableauRules.add(this.minRule);
        this.allValuesRule = expr.hasComplexSubRoles() ? new AllValuesRule(this) : new SimpleAllValuesRule(this);
    }

    protected void addAllRules() {
        this.tableauRules = new ArrayList<TableauRule>();
        this.tableauRules.add(this.nominalRule);
        this.tableauRules.add(this.guessRule);
        this.tableauRules.add(this.chooseRule);
        this.tableauRules.add(this.maxRule);
        this.tableauRules.add(this.dataCardRule);
        this.tableauRules.add(this.dataSatRule);
        this.tableauRules.add(this.unfoldingRule);
        this.tableauRules.add(this.disjunctionRule);
        this.tableauRules.add(this.someValuesRule);
        this.tableauRules.add(this.minRule);
        this.allValuesRule = new AllValuesRule(this);
    }

    protected boolean implicitNominals() {
        Collection<Rule> rules = this.abox.getKB().getNormalizedRules().values();
        for (Rule rule : rules) {
            if (rule == null) continue;
            for (RuleAtom ruleAtom : rule.getBody()) {
                if (!(ruleAtom instanceof DifferentIndividualsAtom)) continue;
                return true;
            }
            for (RuleAtom ruleAtom : rule.getHead()) {
                if (!(ruleAtom instanceof SameIndividualAtom)) continue;
                return true;
            }
        }
        return false;
    }

    public void initialize(Expressivity expressivity) {
        this.mergeList = new ArrayList<NodeMerge>();
        this.blocking = BlockingFactory.createBlocking(expressivity);
        this.configureTableauRules(expressivity);
        for (Branch branch : this.abox.getBranches()) {
            branch.setStrategy(this);
        }
        if (this.abox.isInitialized()) {
            Iterator<Individual> i = this.getInitializeIterator();
            block1: while (i.hasNext()) {
                Individual n = i.next();
                if (n.isMerged()) continue;
                if (n.isConceptRoot()) {
                    this.applyUniversalRestrictions(n);
                }
                this.allValuesRule.apply(n);
                if (n.isMerged()) continue;
                this.nominalRule.apply(n);
                if (n.isMerged()) continue;
                this.selfRule.apply(n);
                EdgeList allEdges = n.getOutEdges();
                for (int e = 0; e < allEdges.size(); ++e) {
                    Edge edge = allEdges.edgeAt(e);
                    if (edge.getTo().isPruned()) continue;
                    this.applyPropertyRestrictions(edge);
                    if (n.isMerged()) continue block1;
                }
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize started");
        }
        this.abox.setBranch(0);
        this.mergeList.addAll(this.abox.getToBeMerged());
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        Role topRole = this.abox.getRole((ATerm)TermFactory.TOP_OBJECT_PROPERTY);
        Iterator<Individual> i = this.getInitializeIterator();
        while (i.hasNext()) {
            Individual n = i.next();
            if (n.isMerged()) continue;
            this.applyUniversalRestrictions(n);
            if (n.isMerged()) continue;
            this.selfRule.apply(n);
            if (n.isMerged()) continue;
            EdgeList allEdges = n.getOutEdges();
            for (int e = 0; e < allEdges.size(); ++e) {
                Edge edge = allEdges.edgeAt(e);
                if (edge.getTo().isPruned()) continue;
                this.applyPropertyRestrictions(edge);
                if (n.isMerged()) break;
            }
            if (n.isMerged()) continue;
            this.applyPropertyRestrictions(n, topRole, n, DependencySet.INDEPENDENT);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Merging: " + this.mergeList);
        }
        if (!this.mergeList.isEmpty()) {
            this.mergeAll();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Initialize finished");
        }
        this.abox.setBranch(this.abox.getBranches().size() + 1);
        this.abox.stats.treeDepth = 1;
        this.abox.setChanged(true);
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    public abstract void complete(Expressivity var1);

    public Individual createFreshIndividual(Individual parent, DependencySet ds) {
        Individual ind = this.abox.addFreshIndividual(parent, ds);
        this.applyUniversalRestrictions(ind);
        return ind;
    }

    void applyUniversalRestrictions(Individual node) {
        this.addType(node, ATermUtils.TOP, DependencySet.INDEPENDENT);
        Set<Role> reflexives = this.abox.getKB().getRBox().getReflexiveRoles();
        for (Role r : reflexives) {
            if (log.isLoggable(Level.FINE) && !node.hasRNeighbor(r, node)) {
                log.fine("REF : " + node + " " + r);
            }
            this.addEdge(node, r, node, r.getExplainReflexive());
            if (!node.isMerged()) continue;
            return;
        }
        Role topObjProp = this.abox.getKB().getRole((ATerm)ATermUtils.TOP_OBJECT_PROPERTY);
        for (ATermAppl domain : topObjProp.getDomains()) {
            this.addType(node, domain, topObjProp.getExplainDomain(domain));
            if (!node.isMerged()) continue;
        }
        for (ATermAppl range : topObjProp.getRanges()) {
            this.addType(node, range, topObjProp.getExplainRange(range));
            if (!node.isMerged()) continue;
        }
    }

    public void addType(Node node, ATermAppl c, DependencySet ds) {
        Literal l;
        NodeMerge mtc;
        if (this.abox.isClosed()) {
            return;
        }
        node.addType(c, ds);
        if (node.isLiteral() && (mtc = (l = (Literal)node).getMergeToConstant()) != null) {
            l.clearMergeToConstant();
            Literal mergeTo = this.abox.getLiteral((ATerm)mtc.getTarget());
            this.mergeTo(l, mergeTo, mtc.getDepends());
            node = mergeTo;
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addTypeDependency(node.getName(), c, ds);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("ADD: " + node + " " + c + " - " + ds + " " + ds.getExplain());
        }
        if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(node, conj, ds);
                node = node.getSame();
                cs = cs.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.allValuesRule.applyAllValues((Individual)node, c, ds);
        } else if (c.getAFun().equals(ATermUtils.SELFFUN)) {
            ATermAppl pred = (ATermAppl)c.getArgument(0);
            Role role = this.abox.getRole((ATerm)pred);
            if (log.isLoggable(Level.FINE) && !((Individual)node).hasRSuccessor(role, node)) {
                log.fine("SELF: " + node + " " + role + " " + node.getDepends((ATerm)c));
            }
            this.addEdge((Individual)node, role, node, ds);
        }
    }

    protected void updateQueueAddEdge(Individual subj, Role pred, Node obj) {
        Role r;
        ATermAppl max;
        ATermAppl c;
        int j;
        List<ATermAppl> types = subj.getTypes(5);
        int size = types.size();
        for (j = 0; j < size; ++j) {
            c = types.get(j);
            max = (ATermAppl)c.getArgument(0);
            r = this.abox.getRole(max.getArgument(0));
            if (!pred.isSubRoleOf(r)) continue;
            QueueElement newElement = new QueueElement(subj, c);
            this.abox.getCompletionQueue().add(newElement, NodeSelector.MAX_NUMBER);
            this.abox.getCompletionQueue().add(newElement, NodeSelector.CHOOSE);
        }
        if (obj instanceof Individual) {
            types = ((Individual)obj).getTypes(5);
            size = types.size();
            for (j = 0; j < size; ++j) {
                c = types.get(j);
                max = (ATermAppl)c.getArgument(0);
                r = this.abox.getRole(max.getArgument(0));
                Role invR = pred.getInverse();
                if (invR == null || !invR.isSubRoleOf(r)) continue;
                QueueElement newElement = new QueueElement(obj, c);
                this.abox.getCompletionQueue().add(newElement, NodeSelector.MAX_NUMBER);
                this.abox.getCompletionQueue().add(newElement, NodeSelector.CHOOSE);
            }
        }
    }

    public void addEdge(Individual subj, Role pred, Node obj, DependencySet ds) {
        Edge edge = subj.addEdge(pred, obj, ds);
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addEdgeDependency(edge, ds);
        }
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), subj.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), obj.getName());
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.updateQueueAddEdge(subj, pred, obj);
        }
        if (edge != null) {
            if (subj.isBlockable() && obj.isNominal() && !obj.isLiteral() && pred.isInverseFunctional()) {
                Individual o = (Individual)obj;
                int max = 1;
                if (!o.hasDistinctRNeighborsForMin(pred.getInverse(), max, ATermUtils.TOP, true)) {
                    int guessMin = o.getMinCard(pred.getInverse(), ATermUtils.TOP);
                    if (guessMin == 0) {
                        guessMin = 1;
                    }
                    if (guessMin > max) {
                        return;
                    }
                    GuessBranch newBranch = new GuessBranch(this.abox, this, o, pred.getInverse(), guessMin, max, ATermUtils.TOP, ds);
                    this.addBranch(newBranch);
                    if (!newBranch.tryNext()) {
                        return;
                    }
                    if (this.abox.isClosed()) {
                        return;
                    }
                    if (subj.isPruned()) {
                        return;
                    }
                }
            }
            this.applyPropertyRestrictions(subj, pred, obj, ds);
        }
    }

    void applyPropertyRestrictions(Edge edge) {
        this.applyPropertyRestrictions(edge.getFrom(), edge.getRole(), edge.getTo(), edge.getDepends());
    }

    void applyPropertyRestrictions(Individual subj, Role pred, Node obj, DependencySet ds) {
        this.applyDomainRange(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyFunctionality(subj, pred, obj);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        this.applyDisjointness(subj, pred, obj, ds);
        this.allValuesRule.applyAllValues(subj, pred, obj, ds);
        if (subj.isPruned() || obj.isPruned()) {
            return;
        }
        if (pred.isObjectRole()) {
            Individual o = (Individual)obj;
            this.allValuesRule.applyAllValues(o, pred.getInverse(), subj, ds);
            this.checkReflexivitySymmetry(subj, pred, o, ds);
            this.checkReflexivitySymmetry(o, pred.getInverse(), subj, ds);
            this.applyDisjointness(o, pred.getInverse(), subj, ds);
        }
    }

    void applyDomainRange(Individual subj, Role pred, Node obj, DependencySet ds) {
        Set<ATermAppl> domains = pred.getDomains();
        Set<ATermAppl> ranges = pred.getRanges();
        for (ATermAppl domain : domains) {
            if (log.isLoggable(Level.FINE) && !subj.hasType((ATerm)domain)) {
                log.fine("DOM : " + obj + " <- " + pred + " <- " + subj + " : " + ATermUtils.toString(domain));
            }
            this.addType(subj, domain, ds.union(pred.getExplainDomain(domain), this.abox.doExplanation()));
            if (!subj.isPruned() && !obj.isPruned()) continue;
            return;
        }
        for (ATermAppl range : ranges) {
            if (log.isLoggable(Level.FINE) && !obj.hasType((ATerm)range)) {
                log.fine("RAN : " + subj + " -> " + pred + " -> " + obj + " : " + ATermUtils.toString(range));
            }
            this.addType(obj, range, ds.union(pred.getExplainRange(range), this.abox.doExplanation()));
            if (!subj.isPruned() && !obj.isPruned()) continue;
            return;
        }
    }

    void applyFunctionality(Individual subj, Role pred, Node obj) {
        DependencySet maxCardDS;
        DependencySet dependencySet = maxCardDS = pred.isFunctional() ? pred.getExplainFunctional() : subj.hasMax1(pred);
        if (maxCardDS != null) {
            this.maxRule.applyFunctionalMaxRule(subj, pred, ATermUtils.getTop(pred), maxCardDS);
        }
        if (pred.isDatatypeRole() && pred.isInverseFunctional()) {
            this.applyFunctionalMaxRule((Literal)obj, pred, DependencySet.INDEPENDENT);
        } else if (pred.isObjectRole()) {
            Individual val = (Individual)obj;
            Role invR = pred.getInverse();
            DependencySet dependencySet2 = maxCardDS = invR.isFunctional() ? invR.getExplainFunctional() : val.hasMax1(invR);
            if (maxCardDS != null) {
                this.maxRule.applyFunctionalMaxRule(val, invR, ATermUtils.TOP, maxCardDS);
            }
        }
    }

    void applyDisjointness(Individual subj, Role pred, Node obj, DependencySet ds) {
        Set<Role> disjoints = pred.getDisjointRoles();
        if (disjoints.isEmpty()) {
            return;
        }
        EdgeList edges = subj.getEdgesTo(obj);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge otherEdge = edges.edgeAt(i);
            if (!disjoints.contains(otherEdge.getRole())) continue;
            ds = ds.union(otherEdge.getDepends(), this.abox.doExplanation());
            ds = ds.union(pred.getExplainDisjointRole(otherEdge.getRole()), this.abox.doExplanation());
            this.abox.setClash(Clash.disjointProps(subj, ds, pred.getName(), otherEdge.getRole().getName()));
            return;
        }
    }

    void checkReflexivitySymmetry(Individual subj, Role pred, Individual obj, DependencySet ds) {
        if (pred.isAsymmetric() && obj.hasRSuccessor(pred, subj)) {
            EdgeList edges = obj.getEdgesTo(subj, pred);
            ds = ds.union(edges.edgeAt(0).getDepends(), this.abox.doExplanation());
            if (PelletOptions.USE_TRACING) {
                ds = ds.union(pred.getExplainAsymmetric(), this.abox.doExplanation());
            }
            this.abox.setClash(Clash.unexplained(subj, ds, "Antisymmetric property " + pred));
        } else if (subj.equals(obj)) {
            if (pred.isIrreflexive()) {
                this.abox.setClash(Clash.unexplained(subj, ds.union(pred.getExplainIrreflexive(), this.abox.doExplanation()), "Irreflexive property " + pred));
            } else {
                ATermAppl notSelfP = ATermUtils.makeNot((ATerm)ATermUtils.makeSelf(pred.getName()));
                if (subj.hasType((ATerm)notSelfP)) {
                    this.abox.setClash(Clash.unexplained(subj, ds.union(subj.getDepends((ATerm)notSelfP), this.abox.doExplanation()), "Local irreflexive property " + pred));
                }
            }
        }
    }

    protected void applyFunctionalMaxRule(Literal x, Role r, DependencySet ds) {
        Edge edge;
        EdgeList edges = x.getInEdges().getEdges(r);
        if (edges.size() <= 1) {
            return;
        }
        Set<Node> neighbors = edges.getNeighbors(x);
        if (neighbors.size() <= 1) {
            return;
        }
        Individual head = null;
        DependencySet headDS = null;
        for (int edgeIndex = 0; edgeIndex < edges.size(); ++edgeIndex) {
            edge = edges.edgeAt(edgeIndex);
            Individual ind = edge.getFrom();
            if (!ind.isNominal() || head != null && ind.getNominalLevel() >= head.getNominalLevel()) continue;
            head = ind;
            headDS = edge.getDepends();
        }
        if (head == null) {
            head = this.abox.addFreshIndividual(null, ds);
        } else {
            ds = ds.union(headDS, this.abox.doExplanation());
        }
        for (int i = 0; i < edges.size(); ++i) {
            edge = edges.edgeAt(i);
            Individual next = edge.getFrom();
            if (next.isPruned() || head.isSame(next)) continue;
            ds = ds.union(edge.getDepends(), this.abox.doExplanation());
            if (next.isDifferent(head)) {
                ds = ds.union(next.getDifferenceDependency(head), this.abox.doExplanation());
                if (r.isFunctional()) {
                    this.abox.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                    break;
                }
                this.abox.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                break;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("FUNC: " + x + " for prop " + r + " merge " + next + " -> " + head + " " + ds);
            }
            this.mergeTo(next, head, ds);
            if (this.abox.isClosed()) {
                return;
            }
            if (!head.isPruned()) continue;
            ds = ds.union(head.getMergeDependency(true), this.abox.doExplanation());
            head = head.getSame();
        }
    }

    private void mergeLater(Node y, Node z, DependencySet ds) {
        this.mergeList.add(new NodeMerge(y, z, ds));
    }

    public void mergeAll() {
        if (this.mergingAll) {
            return;
        }
        this.mergingAll = true;
        while (!(this.merging || this.mergeList.isEmpty() || this.abox.isClosed())) {
            NodeMerge merge = this.mergeList.remove(0);
            Node y = this.abox.getNode((ATerm)merge.getSource());
            Node z = this.abox.getNode((ATerm)merge.getTarget());
            DependencySet ds = merge.getDepends();
            if (y.isMerged()) {
                ds = ds.union(y.getMergeDependency(true), this.abox.doExplanation());
                y = y.getSame();
            }
            if (z.isMerged()) {
                ds = ds.union(z.getMergeDependency(true), this.abox.doExplanation());
                z = z.getSame();
            }
            if (y.isPruned() || z.isPruned()) continue;
            this.mergeTo(y, z, ds);
        }
        this.mergingAll = false;
    }

    public void mergeTo(Node y, Node z, DependencySet ds) {
        if (this.abox.getBranch() >= 0 && PelletOptions.TRACK_BRANCH_EFFECTS) {
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), y.getName());
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addMergeDependency(y.getName(), z.getName(), ds);
        }
        if (y.isDifferent(z)) {
            this.abox.setClash(Clash.nominal(y, y.getDifferenceDependency(z).union(ds, this.abox.doExplanation())));
            return;
        }
        if (!y.isSame(z)) {
            this.abox.setChanged(true);
            if (this.merging) {
                this.mergeLater(y, z, ds);
                return;
            }
            this.merging = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine("MERG: " + y + " -> " + z + " " + ds);
            }
            ds = ds.copy(this.abox.getBranch());
            if (y instanceof Literal && z instanceof Literal) {
                this.mergeLiterals((Literal)y, (Literal)z, ds);
            } else if (y instanceof Individual && z instanceof Individual) {
                this.mergeIndividuals((Individual)y, (Individual)z, ds);
            } else {
                throw new InternalReasonerException("Invalid merge operation!");
            }
        }
        this.merging = false;
        this.mergeAll();
    }

    protected void mergeIndividuals(Individual y, Individual x, DependencySet ds) {
        y.setSame(x, ds);
        x.setNominalLevel(Math.min(x.getNominalLevel(), y.getNominalLevel()));
        Map<ATermAppl, DependencySet> types = y.getDepends();
        for (Map.Entry<ATermAppl, DependencySet> entry : types.entrySet()) {
            ATermAppl yType = entry.getKey();
            DependencySet finalDS = ds.union(entry.getValue(), this.abox.doExplanation());
            this.addType(x, yType, finalDS);
        }
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            if (y.equals(z)) {
                this.addEdge(x, r, x, finalDS);
            } else if (x.hasSuccessor(z)) {
                this.addEdge(x, r.getInverse(), z, finalDS);
            } else {
                this.addEdge(z, r, x, finalDS);
            }
            z.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
        EdgeList outEdges = y.getOutEdges();
        for (int e = 0; e < outEdges.size(); ++e) {
            Edge edge = outEdges.edgeAt(e);
            Node z = edge.getTo();
            if (!z.isNominal() || y.equals(z)) continue;
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(x, r, z, finalDS);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
    }

    protected void mergeLiterals(Literal y, Literal x, DependencySet ds) {
        y.setSame(x, ds);
        x.addAllTypes(y.getDepends(), ds);
        EdgeList inEdges = y.getInEdges();
        for (int e = 0; e < inEdges.size(); ++e) {
            Edge edge = inEdges.edgeAt(e);
            Individual z = edge.getFrom();
            Role r = edge.getRole();
            DependencySet finalDS = ds.union(edge.getDepends(), this.abox.doExplanation());
            this.addEdge(z, r, x, finalDS);
            z.removeEdge(edge);
            if (this.abox.getBranch() < 0 || !PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            this.abox.getBranchEffectTracker().add(this.abox.getBranch(), z.getName());
        }
        x.inheritDifferents(y, ds);
        y.prune(ds);
        if (x.getNodeDepends() == null || y.getNodeDepends() == null) {
            throw new NullPointerException();
        }
    }

    public void restoreLocal(Individual ind, Branch br) {
        ++this.abox.stats.localRestores;
        this.abox.setClash(null);
        this.abox.setBranch(br.getBranch());
        HashMap<Node, Boolean> visited = new HashMap<Node, Boolean>();
        this.restoreLocal(ind, br.getBranch(), visited);
        for (Map.Entry entry : visited.entrySet()) {
            boolean restored = (Boolean)entry.getValue();
            if (!restored) continue;
            this.allValuesRule.apply((Individual)entry.getKey());
        }
    }

    private void restoreLocal(Individual ind, int branch, Map<Node, Boolean> visited) {
        boolean restored = ind.restore(branch);
        visited.put(ind, restored);
        if (restored) {
            for (Edge edge : ind.getOutEdges()) {
                Node succ = edge.getTo();
                if (visited.containsKey(succ)) continue;
                if (succ.isLiteral()) {
                    visited.put(succ, Boolean.FALSE);
                    succ.restore(branch);
                    continue;
                }
                this.restoreLocal((Individual)succ, branch, visited);
            }
            for (Edge edge : ind.getInEdges()) {
                Individual pred = edge.getFrom();
                if (visited.containsKey(pred)) continue;
                this.restoreLocal(pred, branch, visited);
            }
        }
    }

    public void restore(Branch br) {
        this.abox.setBranch(br.getBranch());
        this.abox.setClash(null);
        this.abox.rulesNotApplied = true;
        this.mergeList.clear();
        List<ATermAppl> nodeList = this.abox.getNodeNames();
        if (log.isLoggable(Level.FINE)) {
            log.fine("RESTORE: Branch " + br.getBranch());
        }
        if (PelletOptions.USE_COMPLETION_QUEUE) {
            this.abox.getCompletionQueue().clearQueue(NodeSelector.UNIVERSAL);
            this.abox.getCompletionQueue().restore(br.getBranch());
        }
        if (PelletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this.abox.getIncrementalChangeTracker().clear();
        }
        int nodeCount = nodeList.size();
        int deleteBlock = 0;
        for (int i = 0; i < nodeCount; ++i) {
            ATermAppl a = nodeList.get(i);
            Node node = this.abox.getNode((ATerm)a);
            if (node.getNodeDepends() == null || node.getNodeDepends().getBranch() > br.getBranch()) {
                this.abox.removeNode(a);
                if (node.isMerged()) {
                    node.undoSetSame();
                }
                ++deleteBlock;
                continue;
            }
            if (deleteBlock > 0) {
                List<ATermAppl> subList = nodeList.subList(i - deleteBlock, i);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove nodes " + subList);
                }
                subList.clear();
                nodeCount -= deleteBlock;
                i -= deleteBlock;
                deleteBlock = 0;
            }
            if (PelletOptions.TRACK_BRANCH_EFFECTS) continue;
            node.restore(br.getBranch());
        }
        if (deleteBlock > 0) {
            nodeList.subList(nodeCount - deleteBlock, nodeCount).clear();
        }
        if (PelletOptions.TRACK_BRANCH_EFFECTS) {
            Set<ATermAppl> effected = this.abox.getBranchEffectTracker().removeAll(br.getBranch() + 1);
            for (ATermAppl a : effected) {
                Node n = this.abox.getNode((ATerm)a);
                if (n == null) continue;
                n.restore(br.getBranch());
            }
        }
        this.restoreAllValues();
        if (log.isLoggable(Level.FINE)) {
            this.abox.printTree();
        }
        if (!this.abox.isClosed()) {
            this.abox.validate();
        }
    }

    public void addBranch(Branch newBranch) {
        this.abox.getBranches().add(newBranch);
        if (newBranch.getBranch() != this.abox.getBranches().size()) {
            throw new RuntimeException("Invalid branch created: " + newBranch.getBranch() + " != " + this.abox.getBranches().size());
        }
        this.completionTimer.check();
        if (PelletOptions.USE_INCREMENTAL_DELETION) {
            this.abox.getKB().getDependencyIndex().addBranchAddDependency(newBranch);
        }
    }

    void printBlocked() {
        int blockedCount = 0;
        StringBuffer blockedNodes = new StringBuffer();
        IndividualIterator n = this.abox.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            ATermAppl x = node.getName();
            if (!this.blocking.isBlocked(node)) continue;
            ++blockedCount;
            blockedNodes.append(x).append(" ");
        }
        log.fine("Blocked nodes " + blockedCount + " [" + blockedNodes + "]");
    }

    public String toString() {
        String name = this.getClass().getName();
        int lastIndex = name.lastIndexOf(46);
        return name.substring(lastIndex + 1);
    }

    protected void restoreAllValues() {
        IndividualIterator i = new IndividualIterator(this.abox);
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.allValuesRule.apply(ind);
        }
    }
}

