/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.RulesToReteTranslator;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DefaultAtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.Pair;

public class ContinuousReteTransformer {
    private static final String PREFIX = "tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:";
    private static final ATermAppl DUMMY = ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:slot-filler");
    private static final int RULEPOS = 1;
    private static final int VARSTARTPOS = 4;
    public static final ATermAppl VARBINDING = ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:variable-binding");
    private static int ruleNumber = 0;
    private ABox abox;
    private AtomFilter filter;
    private Map<Rule, ATermAppl> reverseRuleMap;
    private Map<ATermAppl, Pair<Rule, List<AtomVariable>>> ruleMap;
    private RulesToReteTranslator translator;

    public ContinuousReteTransformer(ABox abox) {
        this.abox = abox;
        this.filter = new AtomFilter();
        this.ruleMap = new HashMap<ATermAppl, Pair<Rule, List<AtomVariable>>>();
        this.reverseRuleMap = new HashMap<Rule, ATermAppl>();
        this.translator = new RulesToReteTranslator(abox);
    }

    protected ATermAppl getRuleID(Rule rule) {
        ATermAppl id = this.reverseRuleMap.get(rule);
        if (id == null) {
            id = ATermUtils.makeTermAppl("tag:clarkparsia.info,2007:pellet:dl-safe-rules:continuous-rete:rule-" + ruleNumber++);
            this.reverseRuleMap.put(rule, id);
        }
        return id;
    }

    public com.clarkparsia.pellet.rules.rete.Rule transformRule(Rule rule) {
        ATermAppl ruleID = this.getRuleID(rule);
        DependencySet ds = DependencySet.INDEPENDENT;
        TreeSet<ATerm> vars = new TreeSet<ATerm>(Comparators.termComparator);
        ArrayList<TermTuple> body = new ArrayList<TermTuple>();
        HashMap<ATermAppl, AtomVariable> varToVar = new HashMap<ATermAppl, AtomVariable>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            TermTuple bodyTerm;
            ruleAtom.accept(this.filter);
            if (!this.filter.isSafe() || (bodyTerm = this.translator.translateAtom(ruleAtom, ds)) == null) continue;
            body.add(bodyTerm);
            for (AtomVariable atomVariable : VariableUtils.getVars(ruleAtom)) {
                Pair<ATermAppl, DependencySet> translatedVar = this.translator.translateAtomObject(atomVariable);
                ATermAppl var = (ATermAppl)translatedVar.first;
                varToVar.put(var, atomVariable);
                vars.add((ATerm)var);
            }
        }
        ArrayList<ATermAppl> headTerms = new ArrayList<ATermAppl>();
        headTerms.add(VARBINDING);
        headTerms.add(ruleID);
        headTerms.add(DUMMY);
        headTerms.add(DUMMY);
        headTerms.addAll(vars);
        List<TermTuple> list = Collections.singletonList(new TermTuple(DependencySet.INDEPENDENT, (List<ATermAppl>)headTerms));
        ArrayList ruleVars = new ArrayList(vars.size());
        for (ATermAppl aTermAppl : vars) {
            ruleVars.add(varToVar.get(aTermAppl));
        }
        this.ruleMap.put(ruleID, new Pair(rule, ruleVars));
        return new com.clarkparsia.pellet.rules.rete.Rule(body, list);
    }

    public Pair<Rule, VariableBinding> translateFact(Fact fact) {
        Pair<Rule, VariableBinding> partialApplication = null;
        if (fact.getElements().size() >= 4 && ((ATermAppl)fact.getElements().get(0)).equals(VARBINDING)) {
            Pair<Rule, List<AtomVariable>> ruleVarPair = this.ruleMap.get(fact.getElements().get(1));
            Rule rule = (Rule)ruleVarPair.first;
            List vars = (List)ruleVarPair.second;
            List constants = fact.getElements().subList(4, fact.getElements().size());
            if (vars.size() != constants.size()) {
                throw new InternalReasonerException("Variable list doesn't match constants!");
            }
            VariableBinding binding = new VariableBinding(this.abox);
            for (int i = 0; i < vars.size(); ++i) {
                ((AtomVariable)vars.get(i)).accept(new BindingSetter(binding, (ATermAppl)constants.get(i)));
            }
            partialApplication = new Pair<Rule, VariableBinding>(rule, binding);
        }
        return partialApplication;
    }

    private static class BindingSetter
    extends DefaultAtomObjectVisitor {
        private VariableBinding binding;
        private ATermAppl constant;

        public BindingSetter(VariableBinding binding, ATermAppl constant) {
            this.binding = binding;
            this.constant = constant;
        }

        @Override
        public void visit(AtomDVariable variable) {
            this.binding.set(variable, this.constant);
        }

        @Override
        public void visit(AtomIVariable variable) {
            this.binding.set(variable, this.constant);
        }
    }

    private class AtomFilter
    implements RuleAtomVisitor {
        private boolean result = false;

        private AtomFilter() {
        }

        public boolean isSafe() {
            return this.result;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this.result = false;
        }

        @Override
        public void visit(ClassAtom atom) {
            ATermAppl c = (ATermAppl)atom.getPredicate();
            this.result = ContinuousReteTransformer.this.abox.getKB().getTBox().isPrimitive(c);
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.result = false;
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this.result = false;
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this.result = ContinuousReteTransformer.this.abox.getRole((ATerm)atom.getPredicate()).isSimple();
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this.result = false;
        }
    }
}

