/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.mansyntaxrenderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.OWLRendererIOException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class AbstractRenderer {
    private ShortFormProvider shortFormProvider;
    private int lastNewLinePos = -1;
    private int currentPos;
    private Writer writer;
    private List<Integer> tabs;
    private boolean useTabbing = true;
    private boolean useWrapping = true;

    public AbstractRenderer(Writer writer, ShortFormProvider shortFormProvider) {
        this.writer = writer;
        this.shortFormProvider = shortFormProvider;
        this.tabs = new ArrayList<Integer>();
        this.pushTab(0);
    }

    public void setUseTabbing(boolean useTabbing) {
        this.useTabbing = useTabbing;
    }

    public void setUseWrapping(boolean useWrapping) {
        this.useWrapping = useWrapping;
    }

    public boolean isUseWrapping() {
        return this.useWrapping;
    }

    public boolean isUseTabbing() {
        return this.useTabbing;
    }

    public void flush() throws OWLRendererException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OWLRendererIOException(e);
        }
    }

    protected void pushTab(int size) {
        this.tabs.add(0, size);
    }

    protected void incrementTab(int increment) {
        int base = 0;
        if (!this.tabs.isEmpty()) {
            base = this.tabs.get(0);
        }
        this.tabs.add(0, base + increment);
    }

    protected void popTab() {
        this.tabs.remove(0);
    }

    protected void writeTab() {
        int tab = this.tabs.get(0);
        for (int i = 0; i < tab; ++i) {
            this.write(" ");
        }
    }

    protected int getIndent() {
        return this.currentPos - this.lastNewLinePos - 2;
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int indexOfNewLine = s.indexOf(10);
        if (indexOfNewLine != -1) {
            this.lastNewLinePos = this.currentPos + indexOfNewLine;
        }
        this.currentPos += s.length();
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    protected void write(char ch) {
        this.write(Character.toString(ch));
    }

    protected void write(String s, int lineLen) {
        StringTokenizer tokenizer = new StringTokenizer(s, " \n\t-", true);
        int currentLineLength = 0;
        while (tokenizer.hasMoreTokens()) {
            String curToken = tokenizer.nextToken();
            this.write(curToken);
            if (curToken.equals("\n")) {
                this.writeTab();
            }
            if ((currentLineLength += curToken.length()) <= lineLen || curToken.trim().length() == 0 || !tokenizer.hasMoreTokens()) continue;
            this.writeNewLine();
            currentLineLength = 0;
        }
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void write(ManchesterOWLSyntax keyword) {
        this.write(" ", keyword, " ");
    }

    protected void writeFrameKeyword(ManchesterOWLSyntax keyword) {
        this.write("", keyword, ": ");
    }

    protected void writeSectionKeyword(ManchesterOWLSyntax keyword) {
        this.write(" ", keyword, ": ");
    }

    protected void writeNewLine() {
        this.write("\n");
        if (this.useTabbing) {
            this.writeTab();
        }
    }

    protected void write(String prefix, ManchesterOWLSyntax keyword, String suffix) {
        this.write(prefix);
        this.write(keyword.toString());
        this.write(suffix);
    }

    protected ShortFormProvider getShortFormProvider() {
        return this.shortFormProvider;
    }
}

