/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.rdfxml;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.rdf.rdfxml.RDFXMLRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class RDFXMLExplanationRenderer
implements ExplanationRenderer {
    private Set<OWLAxiom> axioms;
    private Writer writer;

    public void startRendering(Writer writer) {
        this.writer = writer;
        this.axioms = new HashSet<OWLAxiom>();
    }

    public void render(OWLAxiom axiom, Set<Set<OWLAxiom>> explanations) {
        this.axioms.add(axiom);
        for (Set<OWLAxiom> explanation : explanations) {
            this.axioms.addAll(explanation);
        }
    }

    public void endRendering() throws IOException {
        OWLOntology ontology = OWL.Ontology(this.axioms);
        RDFXMLRenderer renderer = new RDFXMLRenderer(OntologyUtils.getOWLOntologyManager(), ontology, this.writer);
        renderer.render();
    }
}

