/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.utils.Timers;

public class InterruptReasoningExample {
    private OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
    private PelletInfGraph pellet = (PelletInfGraph)this.model.getGraph();
    private Timers timers;

    public static void main(String[] args) throws Exception {
        PelletOptions.USE_CLASSIFICATION_MONITOR = PelletOptions.MonitorType.NONE;
        InterruptReasoningExample test = new InterruptReasoningExample();
        test.parse();
        test.consistency();
        test.classify();
        test.realize();
        test.query();
    }

    public InterruptReasoningExample() {
        this.timers = this.pellet.getKB().timers;
        this.timers.createTimer("complete").setTimeout((long)Timeouts.CONSISTENCY);
        this.timers.createTimer("classify").setTimeout((long)Timeouts.CLASSIFY);
        this.timers.createTimer("realize").setTimeout((long)Timeouts.REALIZE);
    }

    public void parse() {
        System.out.print("Parsing the ontology...");
        this.model.read("file:test/data/modularity/wine.owl");
        System.out.println("finished");
        System.out.println();
    }

    public void consistency() throws TimeoutException {
        System.out.println("Consistency Timeout: " + Timeouts.CONSISTENCY + "ms");
        System.out.print("Checking consistency...");
        this.model.prepare();
        System.out.println("finished in " + this.timers.getTimer("isConsistent").getLast());
        System.out.println();
    }

    public void classify() {
        System.out.println("Classify Timeout: " + Timeouts.CLASSIFY + "ms");
        System.out.print("Classifying...");
        try {
            ((PelletInfGraph)this.model.getGraph()).classify();
            System.out.println("finished in " + this.timers.getTimer("classify").getLast() + "ms");
        }
        catch (TimeoutException e) {
            System.out.println("interrupted after " + this.timers.getTimer("classify").getElapsed() + "ms");
        }
        System.out.println("Classified: " + this.pellet.isClassified());
        System.out.println();
    }

    public void realize() {
        if (!this.pellet.isClassified()) {
            return;
        }
        System.out.println("Realize Timeout: " + Timeouts.REALIZE + "ms");
        System.out.print("Realizing...");
        try {
            this.pellet.realize();
            System.out.println("finished in " + this.timers.getTimer("realize").getLast() + "ms");
        }
        catch (TimeoutException e) {
            System.out.println("interrupted after " + this.timers.getTimer("realize").getElapsed() + "ms");
        }
        System.out.println("Realized: " + this.pellet.isRealized());
        System.out.println();
    }

    public void query() {
        int[] timeouts;
        for (int timeout : timeouts = new int[]{0, 200, 2000, 20000}) {
            this.timers.mainTimer.setTimeout((long)timeout);
            System.out.println("Query Timeout: " + timeout + "ms");
            this.getInstances(WINE.AmericanWine);
            this.execQuery(WINE.query);
            System.out.println();
        }
    }

    public void getInstances(Resource cls) {
        System.out.print("Retrieving instances of " + cls.getLocalName() + "...");
        this.timers.mainTimer.restart();
        try {
            ExtendedIterator results = this.model.listIndividuals(cls);
            int size = results.toList().size();
            System.out.print("completed in " + this.timers.mainTimer.getElapsed() + "ms");
            System.out.println(" (" + size + " results)");
        }
        catch (TimeoutException e) {
            System.out.println("interrupted after " + this.timers.mainTimer.getElapsed() + "ms");
        }
    }

    public void execQuery(Query query) {
        System.out.print("Running SPARQL query...");
        this.timers.mainTimer.restart();
        try {
            ResultSet results = SparqlDLExecutionFactory.create((Query)query, (Model)this.model).execSelect();
            int size = ResultSetFormatter.consume((ResultSet)results);
            System.out.print("completed in " + this.timers.mainTimer.getElapsed() + "ms");
            System.out.println(" (" + size + " results)");
        }
        catch (TimeoutException e) {
            System.out.println("interrupted after " + this.timers.mainTimer.getElapsed() + "ms");
        }
    }

    public static class WINE {
        public static final String NS = "http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine#";
        public static final Resource AmericanWine = ResourceFactory.createResource((String)"http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine#AmericanWine");
        public static final Query query = QueryFactory.create((String)"PREFIX wine: <http://www.w3.org/TR/2003/PR-owl-guide-20031209/wine#>\nSELECT * WHERE {\n   ?x a wine:RedWine ; \n      wine:madeFromGrape ?y \n}");
    }

    public static class Timeouts {
        public static int CONSISTENCY = 5000;
        public static int CLASSIFY = 50000;
        public static int REALIZE = 1000;
    }
}

