/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.oboformat;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import org.semanticweb.owlapi.annotations.OwlapiModule;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.oboformat.OBOFormatOWLAPIParser;
import org.semanticweb.owlapi.oboformat.OBOFormatStorer;

@OwlapiModule
public class OWLAPIOBOModule
extends AbstractModule {
    protected void configure() {
        this.configureParsers();
        this.configureStorers();
    }

    protected void configureStorers() {
        this.multibind(OWLStorer.class, OBOFormatStorer.class);
    }

    protected void configureParsers() {
        this.multibind(OWLParser.class, OBOFormatOWLAPIParser.class);
    }

    @SafeVarargs
    private final <T> Multibinder<T> multibind(Class<T> type, Class<? extends T> ... implementations) {
        Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
        for (Class<? extends T> i : implementations) {
            binder.addBinding().to(i);
        }
        return binder;
    }
}

