/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;

public class Clause {
    protected String tag;
    @Nonnull
    protected final Collection<Object> values = new ArrayList<Object>();
    @Nonnull
    protected final Collection<Xref> xrefs = new ArrayList<Xref>();
    @Nonnull
    protected final Collection<QualifierValue> qualifierValues = new ArrayList<QualifierValue>();

    public Clause(@Nonnull OBOFormatConstants.OboFormatTag tag) {
        this(tag.getTag());
    }

    public Clause(String tag) {
        this.tag = tag;
    }

    public Clause(String tag, String value) {
        this(tag);
        this.setValue(value);
    }

    public Clause(@Nonnull OBOFormatConstants.OboFormatTag tag, String value) {
        this(tag.getTag(), value);
    }

    @Deprecated
    public Clause() {
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Nonnull
    public Collection<Object> getValues() {
        return this.values;
    }

    public void setValues(@Nonnull Collection<Object> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void setValue(Object v) {
        this.values.clear();
        this.values.add(v);
    }

    public void addValue(Object v) {
        this.values.add(v);
    }

    @Nullable
    public Object getValue() {
        Object value = null;
        if (!this.values.isEmpty()) {
            value = this.values.iterator().next();
        }
        return value;
    }

    @Nullable
    public <T> T getValue(@Nonnull Class<T> cls) {
        Object value = this.getValue();
        if (value != null && value.getClass().isAssignableFrom(cls)) {
            return cls.cast(value);
        }
        return null;
    }

    @Nullable
    public Object getValue2() {
        Object value = null;
        if (this.values.size() > 1) {
            Iterator<Object> iterator = this.values.iterator();
            iterator.next();
            value = iterator.next();
        }
        return value;
    }

    @Nullable
    public <T> T getValue2(@Nonnull Class<T> cls) {
        Object value = this.getValue2();
        if (value != null && value.getClass().isAssignableFrom(cls)) {
            return cls.cast(value);
        }
        return null;
    }

    @Nonnull
    public Collection<Xref> getXrefs() {
        return this.xrefs;
    }

    public void setXrefs(@Nonnull Collection<Xref> xrefs) {
        this.xrefs.clear();
        this.xrefs.addAll(xrefs);
    }

    public void addXref(Xref xref) {
        this.xrefs.add(xref);
    }

    @Nonnull
    public Collection<QualifierValue> getQualifierValues() {
        return this.qualifierValues;
    }

    public void setQualifierValues(@Nonnull Collection<QualifierValue> qualifierValues) {
        this.qualifierValues.clear();
        this.qualifierValues.addAll(qualifierValues);
    }

    public void addQualifierValue(QualifierValue qv) {
        this.qualifierValues.add(qv);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder(this.tag);
        sb.append('(');
        for (Object ob : this.values) {
            sb.append(' ');
            sb.append(ob);
        }
        if (!this.qualifierValues.isEmpty()) {
            sb.append('{');
            for (QualifierValue qv : this.qualifierValues) {
                sb.append(qv);
                sb.append(' ');
            }
            sb.append('}');
        }
        if (!this.xrefs.isEmpty()) {
            sb.append('[');
            for (Xref x : this.xrefs) {
                sb.append(x);
                sb.append(' ');
            }
            sb.append(']');
        }
        sb.append(')');
        return sb.toString();
    }

    private static boolean collectionsEquals(@Nullable Collection<?> c1, @Nullable Collection<?> c2) {
        if (c1 == null || c1.isEmpty()) {
            return c2 == null || c2.isEmpty();
        }
        if (c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        for (Object x : c1) {
            if (c2.contains(x)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 29791 * this.qualifierValues.hashCode() + 31 * this.xrefs.hashCode() + 961 * this.values.hashCode() + (this.tag == null ? 0 : this.tag.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Clause)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Clause other = (Clause)obj;
        if (!this.getTag().equals(other.getTag())) {
            return false;
        }
        if (this.getValues().size() == 1 && other.getValues().size() == 1) {
            Object v2;
            Object v1 = this.getValue();
            if (!(v1 == (v2 = other.getValue()) || v1 == null || v1.equals(v2) || Boolean.TRUE.equals(v1) && "true".equals(v2) || Boolean.TRUE.equals(v2) && "true".equals(v1) || Boolean.FALSE.equals(v1) && "false".equals(v2) || Boolean.FALSE.equals(v2) && "false".equals(v1))) {
                return false;
            }
        } else if (!this.getValues().equals(other.getValues())) {
            return false;
        }
        if (!Clause.collectionsEquals(this.xrefs, other.getXrefs())) {
            return false;
        }
        return Clause.collectionsEquals(this.qualifierValues, other.getQualifierValues());
    }
}

