/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionVisitor {
    protected static final Logger LOG = LoggerFactory.getLogger(MacroExpansionVisitor.class);
    @Nonnull
    private final OWLOntology inputOntology;
    @Nonnull
    private final OWLOntologyManager manager;
    @Nonnull
    private final Visitor visitor;
    @Nonnull
    protected ManchesterSyntaxTool manchesterSyntaxTool;

    public MacroExpansionVisitor(@Nonnull OWLOntology inputOntology) {
        this.inputOntology = inputOntology;
        this.visitor = new Visitor(inputOntology);
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(inputOntology);
        this.manager = inputOntology.getOWLOntologyManager();
    }

    public OWLOntology expandAll() {
        HashSet<OWLAxiom> newAxioms = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> rmAxioms = new HashSet<OWLAxiom>();
        Iterator i$ = this.inputOntology.getAxioms().iterator();
        while (i$.hasNext()) {
            OWLAxiom ax;
            OWLAxiom exAx = ax = (OWLAxiom)i$.next();
            if (ax instanceof OWLSubClassOfAxiom) {
                exAx = this.visitor.visit((OWLSubClassOfAxiom)ax);
            } else if (ax instanceof OWLEquivalentClassesAxiom) {
                exAx = this.visitor.visit((OWLEquivalentClassesAxiom)ax);
            } else if (ax instanceof OWLClassAssertionAxiom) {
                exAx = this.visitor.visit((OWLClassAssertionAxiom)ax);
            } else if (ax instanceof OWLAnnotationAssertionAxiom) {
                for (OWLAxiom expandedAx : this.expand((OWLAnnotationAssertionAxiom)ax)) {
                    if (ax.equals(expandedAx)) continue;
                    newAxioms.add(expandedAx);
                    rmAxioms.add(ax);
                }
            }
            if (ax.equals(exAx)) continue;
            newAxioms.add(exAx);
            rmAxioms.add(ax);
        }
        this.manager.addAxioms(this.inputOntology, newAxioms);
        this.manager.removeAxioms(this.inputOntology, rmAxioms);
        return this.inputOntology;
    }

    @Nonnull
    private Set<OWLAxiom> expand(@Nonnull OWLAnnotationAssertionAxiom ax) {
        OWLAnnotationProperty prop = ax.getProperty();
        String expandTo = (String)this.visitor.expandAssertionToMap.get(prop.getIRI());
        HashSet<OWLAxiom> setAx = new HashSet<OWLAxiom>();
        if (expandTo != null) {
            IRI axValIRI = (IRI)ax.getValue();
            OWLClass axValClass = this.visitor.dataFactory.getOWLClass(axValIRI);
            if (this.inputOntology.getDeclarationAxioms((OWLEntity)axValClass).isEmpty()) {
                OWLDeclarationAxiom newAx = this.visitor.dataFactory.getOWLDeclarationAxiom((OWLEntity)axValClass);
                this.manager.addAxiom(this.inputOntology, (OWLAxiom)newAx);
                this.manchesterSyntaxTool = new ManchesterSyntaxTool(this.inputOntology);
            }
            LOG.info("Template to Expand {}", (Object)expandTo);
            expandTo = expandTo.replaceAll("\\?X", this.manchesterSyntaxTool.getId((IRI)ax.getSubject()));
            expandTo = expandTo.replaceAll("\\?Y", this.manchesterSyntaxTool.getId(axValIRI));
            LOG.info("Expanding {}", (Object)expandTo);
            try {
                Set<OntologyAxiomPair> setAxp = this.manchesterSyntaxTool.parseManchesterExpressionFrames(expandTo);
                for (OntologyAxiomPair axp : setAxp) {
                    setAx.add(axp.getAxiom());
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return setAx;
    }

    public void dispose() {
        this.manchesterSyntaxTool.dispose();
    }

    private class Visitor
    extends AbstractMacroExpansionVisitor {
        Visitor(OWLOntology inputOntology) {
            super(inputOntology);
        }

        @Override
        @Nullable
        protected OWLClassExpression expandOWLObjSomeVal(@Nonnull OWLClassExpression filler, @Nonnull OWLObjectPropertyExpression p) {
            return this.expandObject(filler, p);
        }

        @Override
        protected OWLClassExpression expandOWLObjHasVal(@Nonnull OWLObjectHasValue desc, OWLIndividual filler, @Nonnull OWLObjectPropertyExpression p) {
            OWLClassExpression result = this.expandObject(filler, p);
            if (result != null) {
                result = this.dataFactory.getOWLObjectSomeValuesFrom(desc.getProperty(), result);
            }
            return result;
        }

        @Nullable
        OWLClassExpression expandObject(Object filler, @Nonnull OWLObjectPropertyExpression p) {
            OWLClassExpression result = null;
            IRI iri = ((OWLObjectProperty)p).getIRI();
            IRI templateVal = null;
            if (this.expandExpressionMap.containsKey(iri)) {
                OWLIndividual ind;
                Set inds;
                if (filler instanceof OWLObjectOneOf && (inds = ((OWLObjectOneOf)filler).getIndividuals()).size() == 1 && (ind = (OWLIndividual)inds.iterator().next()) instanceof OWLNamedIndividual) {
                    templateVal = ((OWLNamedObject)ind).getIRI();
                }
                if (filler instanceof OWLNamedObject) {
                    templateVal = ((OWLNamedObject)filler).getIRI();
                }
                if (templateVal != null) {
                    String tStr = (String)this.expandExpressionMap.get(iri);
                    String exStr = tStr.replaceAll("\\?Y", MacroExpansionVisitor.this.manchesterSyntaxTool.getId(templateVal));
                    try {
                        result = MacroExpansionVisitor.this.manchesterSyntaxTool.parseManchesterExpression(exStr);
                    }
                    catch (ParserException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return result;
        }
    }
}

