/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OntologyAxiomPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroExpansionGCIVisitor {
    protected static final Logger LOG = LoggerFactory.getLogger(MacroExpansionGCIVisitor.class);
    private final OWLOntology inputOntology;
    private final OWLOntologyManager outputManager;
    @Nonnull
    private final OWLOntology outputOntology;
    protected final ManchesterSyntaxTool manchesterSyntaxTool;
    private final GCIVisitor visitor;

    public MacroExpansionGCIVisitor(@Nonnull OWLOntology inputOntology, @Nonnull OWLOntologyManager outputManager) {
        this.inputOntology = inputOntology;
        this.visitor = new GCIVisitor(inputOntology);
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(inputOntology);
        this.outputManager = outputManager;
        try {
            this.outputOntology = outputManager.createOntology(inputOntology.getOntologyID());
        }
        catch (Exception ex) {
            throw new OWLRuntimeException((Throwable)ex);
        }
    }

    protected void output(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            LOG.error("no axiom");
            return;
        }
        AddAxiom addAx = new AddAxiom(this.outputOntology, axiom);
        try {
            this.outputManager.applyChange((OWLOntologyChange)addAx);
        }
        catch (Exception e) {
            LOG.error("COULD NOT TRANSLATE AXIOM", (Throwable)e);
        }
    }

    public OWLOntology createGCIOntology() {
        for (OWLAxiom ax : this.inputOntology.getAxioms()) {
            if (ax instanceof OWLSubClassOfAxiom) {
                this.visitor.visit((OWLSubClassOfAxiom)ax);
                continue;
            }
            if (ax instanceof OWLEquivalentClassesAxiom) {
                this.visitor.visit((OWLEquivalentClassesAxiom)ax);
                continue;
            }
            if (ax instanceof OWLClassAssertionAxiom) {
                this.visitor.visit((OWLClassAssertionAxiom)ax);
                continue;
            }
            if (!(ax instanceof OWLAnnotationAssertionAxiom)) continue;
            this.expand((OWLAnnotationAssertionAxiom)ax);
        }
        return this.outputOntology;
    }

    private void expand(@Nonnull OWLAnnotationAssertionAxiom ax) {
        OWLAnnotationProperty prop = ax.getProperty();
        String expandTo = (String)this.visitor.expandAssertionToMap.get(prop.getIRI());
        if (expandTo != null) {
            LOG.info("Template to Expand{}", (Object)expandTo);
            expandTo = expandTo.replaceAll("\\?X", this.manchesterSyntaxTool.getId((IRI)ax.getSubject()));
            expandTo = expandTo.replaceAll("\\?Y", this.manchesterSyntaxTool.getId((IRI)ax.getValue()));
            LOG.info("Expanding {}", (Object)expandTo);
            try {
                Set<OntologyAxiomPair> setAxp = this.manchesterSyntaxTool.parseManchesterExpressionFrames(expandTo);
                for (OntologyAxiomPair axp : setAxp) {
                    this.output(axp.getAxiom());
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void dispose() {
        this.manchesterSyntaxTool.dispose();
    }

    private class GCIVisitor
    extends AbstractMacroExpansionVisitor {
        GCIVisitor(OWLOntology inputOntology) {
            super(inputOntology);
        }

        @Override
        @Nullable
        protected OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, @Nonnull OWLObjectPropertyExpression p) {
            OWLClassExpression gciRHS = this.expandObject(filler, p);
            if (gciRHS != null) {
                OWLObjectSomeValuesFrom gciLHS = this.dataFactory.getOWLObjectSomeValuesFrom(p, filler);
                OWLEquivalentClassesAxiom ax = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS);
                MacroExpansionGCIVisitor.this.output((OWLAxiom)ax);
            }
            return gciRHS;
        }

        @Override
        @Nullable
        protected OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, @Nonnull OWLIndividual filler, @Nonnull OWLObjectPropertyExpression p) {
            OWLClassExpression gciRHS = this.expandObject(filler, p);
            if (gciRHS != null) {
                OWLObjectHasValue gciLHS = this.dataFactory.getOWLObjectHasValue(p, filler);
                OWLEquivalentClassesAxiom ax = this.dataFactory.getOWLEquivalentClassesAxiom((OWLClassExpression)gciLHS, gciRHS);
                MacroExpansionGCIVisitor.this.output((OWLAxiom)ax);
            }
            return gciRHS;
        }

        @Nullable
        private OWLClassExpression expandObject(Object filler, @Nonnull OWLObjectPropertyExpression p) {
            OWLClassExpression result = null;
            IRI iri = ((OWLObjectProperty)p).getIRI();
            IRI templateVal = null;
            if (this.expandExpressionMap.containsKey(iri)) {
                OWLIndividual ind;
                Set inds;
                if (filler instanceof OWLObjectOneOf && (inds = ((OWLObjectOneOf)filler).getIndividuals()).size() == 1 && (ind = (OWLIndividual)inds.iterator().next()) instanceof OWLNamedIndividual) {
                    templateVal = ((OWLNamedObject)ind).getIRI();
                }
                if (filler instanceof OWLNamedObject) {
                    templateVal = ((OWLNamedObject)filler).getIRI();
                }
                if (templateVal != null) {
                    String tStr = (String)this.expandExpressionMap.get(iri);
                    String exStr = tStr.replaceAll("\\?Y", MacroExpansionGCIVisitor.this.manchesterSyntaxTool.getId(templateVal));
                    try {
                        result = MacroExpansionGCIVisitor.this.manchesterSyntaxTool.parseManchesterExpression(exStr);
                    }
                    catch (ParserException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            return result;
        }
    }
}

