/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLDataVisitorExAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMacroExpansionVisitor
extends OWLDataVisitorExAdapter<OWLDataRange>
implements OWLClassExpressionVisitorEx<OWLClassExpression>,
OWLDataVisitorEx<OWLDataRange>,
OWLAxiomVisitorEx<OWLAxiom> {
    static final Logger LOG = LoggerFactory.getLogger(AbstractMacroExpansionVisitor.class);
    final OWLDataFactory dataFactory;
    @Nonnull
    final Map<IRI, String> expandAssertionToMap;
    @Nonnull
    final Map<IRI, String> expandExpressionMap;

    protected AbstractMacroExpansionVisitor(@Nonnull OWLOntology inputOntology) {
        super(null);
        String str;
        OWLAnnotationValue v;
        this.dataFactory = inputOntology.getOWLOntologyManager().getOWLDataFactory();
        this.expandExpressionMap = new HashMap<IRI, String>();
        this.expandAssertionToMap = new HashMap<IRI, String>();
        OWLAnnotationProperty expandExpressionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000424.getIRI());
        OWLAnnotationProperty expandAssertionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000425.getIRI());
        for (OWLObjectProperty p : inputOntology.getObjectPropertiesInSignature()) {
            for (OWLAnnotation a : Searcher.annotations((Collection)inputOntology.filterAxioms(Filters.annotations, (Object)p.getIRI(), Imports.INCLUDED), (OWLAnnotationProperty)expandExpressionAP)) {
                v = a.getValue();
                if (!(v instanceof OWLLiteral)) continue;
                str = ((OWLLiteral)v).getLiteral();
                LOG.info("mapping {} to {}", (Object)p, (Object)str);
                this.expandExpressionMap.put(p.getIRI(), str);
            }
        }
        for (OWLObjectProperty p : inputOntology.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
            for (OWLAnnotation a : Searcher.annotations((Collection)inputOntology.filterAxioms(Filters.annotations, (Object)p.getIRI(), Imports.INCLUDED), (OWLAnnotationProperty)expandAssertionAP)) {
                v = a.getValue();
                if (!(v instanceof OWLLiteral)) continue;
                str = ((OWLLiteral)v).getLiteral();
                LOG.info("assertion mapping {} to {}", (Object)p, (Object)str);
                this.expandAssertionToMap.put(p.getIRI(), str);
            }
        }
    }

    public OWLClassExpression visit(@Nonnull OWLObjectIntersectionOf ce) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : ce.getOperands()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectUnionOf ce) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : ce.getOperands()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectComplementOf ce) {
        return this.dataFactory.getOWLObjectComplementOf((OWLClassExpression)ce.getOperand().accept((OWLClassExpressionVisitorEx)this));
    }

    @Nonnull
    public OWLClassExpression visit(@Nonnull OWLObjectSomeValuesFrom ce) {
        OWLClassExpression filler = (OWLClassExpression)ce.getFiller();
        OWLObjectPropertyExpression p = ce.getProperty();
        OWLClassExpression result = null;
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjSomeVal(filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectSomeValuesFrom(ce.getProperty(), (OWLClassExpression)filler.accept((OWLClassExpressionVisitorEx)this));
        }
        return result;
    }

    @Nullable
    protected abstract OWLClassExpression expandOWLObjSomeVal(@Nonnull OWLClassExpression var1, @Nonnull OWLObjectPropertyExpression var2);

    @Nonnull
    public OWLClassExpression visit(@Nonnull OWLObjectHasValue ce) {
        OWLClassExpression result = null;
        OWLIndividual filler = (OWLIndividual)ce.getFiller();
        OWLObjectPropertyExpression p = ce.getProperty();
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjHasVal(ce, filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectHasValue(ce.getProperty(), filler);
        }
        return result;
    }

    @Nullable
    protected abstract OWLClassExpression expandOWLObjHasVal(@Nonnull OWLObjectHasValue var1, @Nonnull OWLIndividual var2, @Nonnull OWLObjectPropertyExpression var3);

    public OWLClassExpression visit(@Nonnull OWLObjectAllValuesFrom ce) {
        return (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectMinCardinality ce) {
        OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        return this.dataFactory.getOWLObjectMinCardinality(ce.getCardinality(), ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectExactCardinality ce) {
        return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectMaxCardinality ce) {
        OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        return this.dataFactory.getOWLObjectMaxCardinality(ce.getCardinality(), ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataSomeValuesFrom ce) {
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataSomeValuesFrom(ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataAllValuesFrom ce) {
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataAllValuesFrom(ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataHasValue ce) {
        return (OWLClassExpression)ce.asSomeValuesFrom().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLDataExactCardinality ce) {
        return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLDataMaxCardinality ce) {
        int card = ce.getCardinality();
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataMaxCardinality(card, ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataMinCardinality ce) {
        int card = ce.getCardinality();
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataMinCardinality(card, ce.getProperty(), filler);
    }

    public OWLDataRange visit(@Nonnull OWLDataOneOf node) {
        HashSet<OWLDataOneOf> oneOfs = new HashSet<OWLDataOneOf>();
        for (OWLLiteral lit : node.getValues()) {
            oneOfs.add(this.dataFactory.getOWLDataOneOf(new OWLLiteral[]{lit}));
        }
        return (OWLDataRange)this.dataFactory.getOWLDataUnionOf(oneOfs).accept((OWLDataVisitorEx)this);
    }

    public OWLDataRange visit(@Nonnull OWLDataIntersectionOf node) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept((OWLDataVisitorEx)this));
        }
        return this.dataFactory.getOWLDataIntersectionOf(ops);
    }

    public OWLDataRange visit(@Nonnull OWLDataUnionOf node) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept((OWLDataVisitorEx)this));
        }
        return this.dataFactory.getOWLDataUnionOf(ops);
    }

    public OWLAxiom visit(@Nonnull OWLSubClassOfAxiom axiom) {
        return this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)axiom.getSubClass().accept((OWLClassExpressionVisitorEx)this), (OWLClassExpression)axiom.getSuperClass().accept((OWLClassExpressionVisitorEx)this));
    }

    public OWLAxiom visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLDisjointClassesAxiom(ops);
    }

    public OWLAxiom visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getDomain().accept((OWLClassExpressionVisitorEx)this));
    }

    public OWLAxiom visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getDomain().accept((OWLClassExpressionVisitorEx)this));
    }

    public OWLAxiom visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)((OWLClassExpression)axiom.getRange()).accept((OWLClassExpressionVisitorEx)this));
    }

    public OWLAxiom visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        HashSet<Object> descs = new HashSet<Object>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            descs.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLDisjointUnionAxiom(axiom.getOWLClass(), descs);
    }

    public OWLAxiom visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)((OWLDataRange)axiom.getRange()).accept((OWLDataVisitorEx)this));
    }

    public OWLAxiom visit(@Nonnull OWLClassAssertionAxiom axiom) {
        if (axiom.getClassExpression().isAnonymous()) {
            return this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)axiom.getClassExpression().accept((OWLClassExpressionVisitorEx)this), axiom.getIndividual());
        }
        return axiom;
    }

    public OWLAxiom visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLEquivalentClassesAxiom(ops);
    }

    public OWLClassExpression visit(OWLClass ce) {
        return ce;
    }

    public OWLClassExpression visit(OWLObjectHasSelf ce) {
        return ce;
    }

    public OWLClassExpression visit(OWLObjectOneOf ce) {
        return ce;
    }

    public OWLDataRange visit(OWLDatatype node) {
        return node;
    }

    public OWLDataRange visit(OWLDataComplementOf node) {
        return node;
    }

    public OWLAxiom visit(OWLHasKeyAxiom axiom) {
        return axiom;
    }

    public OWLDataRange visit(OWLDatatypeRestriction node) {
        return node;
    }

    public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAnnotationAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSameIndividualAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(SWRLRule rule) {
        return rule;
    }

    public OWLAxiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDatatypeDefinitionAxiom axiom) {
        return axiom;
    }
}

