/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SWRLVariableExtractor;
import uk.ac.manchester.cs.owl.owlapi.OWLLogicalAxiomImplWithEntityAndAnonCaching;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithEntityAndAnonCaching;

public class SWRLRuleImpl
extends OWLLogicalAxiomImplWithEntityAndAnonCaching
implements SWRLRule {
    private static final long serialVersionUID = 40000L;
    private final LinkedHashSet<SWRLAtom> head;
    private final LinkedHashSet<SWRLAtom> body;
    private final boolean containsAnonymousClassExpressions;
    private transient WeakReference<Set<SWRLVariable>> variables = null;
    private transient WeakReference<Set<OWLClassExpression>> classAtomsPredicates = null;
    @Nonnull
    protected static final AtomSimplifier ATOM_SIMPLIFIER = new AtomSimplifier();

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.variables = null;
        this.classAtomsPredicates = null;
    }

    public SWRLRuleImpl(@Nonnull Set<? extends SWRLAtom> body, @Nonnull Set<? extends SWRLAtom> head, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.head = new LinkedHashSet((Collection)OWLAPIPreconditions.checkNotNull(head, (String)"head cannot be null"));
        this.body = new LinkedHashSet((Collection)OWLAPIPreconditions.checkNotNull(body, (String)"body cannot be null"));
        this.containsAnonymousClassExpressions = this.hasAnon();
    }

    public SWRLRule getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new SWRLRuleImpl(this.getBody(), this.getHead(), NO_ANNOTATIONS);
    }

    public OWLAxiom getAnnotatedAxiom(@Nonnull Set<OWLAnnotation> annotations) {
        return new SWRLRuleImpl(this.getBody(), this.getHead(), annotations);
    }

    public SWRLRuleImpl(@Nonnull Set<? extends SWRLAtom> body, @Nonnull Set<? extends SWRLAtom> head) {
        this(body, head, NO_ANNOTATIONS);
    }

    @Nonnull
    public Set<SWRLVariable> getVariables() {
        Set toReturn = null;
        if (this.variables != null) {
            toReturn = (Set)this.variables.get();
        }
        if (toReturn != null) {
            return toReturn;
        }
        SWRLVariableExtractor extractor = new SWRLVariableExtractor();
        this.accept((SWRLObjectVisitor)extractor);
        toReturn = extractor.getVariables();
        this.variables = new WeakReference<Set>(toReturn);
        return toReturn;
    }

    private boolean hasAnon() {
        for (SWRLAtom atom : this.head) {
            if (!(atom instanceof SWRLClassAtom) || !((SWRLClassAtom)atom).getPredicate().isAnonymous()) continue;
            return true;
        }
        for (SWRLAtom atom : this.body) {
            if (!(atom instanceof SWRLClassAtom) || !((SWRLClassAtom)atom).getPredicate().isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnonymousClassExpressions() {
        return this.containsAnonymousClassExpressions;
    }

    public Set<OWLClassExpression> getClassAtomPredicates() {
        LinkedHashSet<OWLClassExpression> toReturn = null;
        if (this.classAtomsPredicates != null) {
            toReturn = (LinkedHashSet<OWLClassExpression>)this.classAtomsPredicates.get();
        }
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = new LinkedHashSet<OWLClassExpression>();
        for (SWRLAtom atom : this.head) {
            if (!(atom instanceof SWRLClassAtom)) continue;
            toReturn.add(((SWRLClassAtom)atom).getPredicate());
        }
        for (SWRLAtom atom : this.body) {
            if (!(atom instanceof SWRLClassAtom)) continue;
            toReturn.add(((SWRLClassAtom)atom).getPredicate());
        }
        this.classAtomsPredicates = new WeakReference(toReturn);
        return toReturn;
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((SWRLRule)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLRule)this);
    }

    public void accept(SWRLObjectVisitor visitor) {
        visitor.visit((SWRLRule)this);
    }

    public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLRule)this);
    }

    public Set<SWRLAtom> getBody() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.body);
    }

    public Set<SWRLAtom> getHead() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.head);
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((SWRLRule)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLRule)this);
    }

    public SWRLRule getSimplified() {
        return (SWRLRule)this.accept(ATOM_SIMPLIFIER);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof SWRLRule)) {
                return false;
            }
            SWRLRule other = (SWRLRule)obj;
            return other.getBody().equals(this.body) && other.getHead().equals(this.head);
        }
        return false;
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.SWRL_RULE;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        SWRLRule other = (SWRLRule)object;
        int diff = SWRLRuleImpl.compareSets(this.getBody(), other.getBody());
        if (diff == 0) {
            diff = SWRLRuleImpl.compareSets(this.getHead(), other.getHead());
        }
        return diff;
    }

    protected static class AtomSimplifier
    implements SWRLObjectVisitorEx<SWRLObject> {
        protected AtomSimplifier() {
        }

        public SWRLRule visit(SWRLRule node) {
            HashSet<SWRLAtom> nodebody = new HashSet<SWRLAtom>();
            for (SWRLAtom atom : node.getBody()) {
                nodebody.add((SWRLAtom)atom.accept((SWRLObjectVisitorEx)this));
            }
            HashSet<SWRLAtom> nodehead = new HashSet<SWRLAtom>();
            for (SWRLAtom atom : node.getHead()) {
                nodehead.add((SWRLAtom)atom.accept((SWRLObjectVisitorEx)this));
            }
            return new SWRLRuleImpl(nodebody, nodehead, OWLObjectImplWithEntityAndAnonCaching.NO_ANNOTATIONS);
        }

        public SWRLClassAtom visit(SWRLClassAtom node) {
            return node;
        }

        public SWRLDataRangeAtom visit(SWRLDataRangeAtom node) {
            return node;
        }

        public SWRLObjectPropertyAtom visit(SWRLObjectPropertyAtom node) {
            return node.getSimplified();
        }

        public SWRLDataPropertyAtom visit(SWRLDataPropertyAtom node) {
            return node;
        }

        public SWRLBuiltInAtom visit(SWRLBuiltInAtom node) {
            return node;
        }

        public SWRLVariable visit(SWRLVariable node) {
            return node;
        }

        public SWRLIndividualArgument visit(SWRLIndividualArgument node) {
            return node;
        }

        public SWRLLiteralArgument visit(SWRLLiteralArgument node) {
            return node;
        }

        public SWRLSameIndividualAtom visit(SWRLSameIndividualAtom node) {
            return node;
        }

        public SWRLDifferentIndividualsAtom visit(SWRLDifferentIndividualsAtom node) {
            return node;
        }
    }
}

