/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public class OWLSubClassOfAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassOfAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLClassExpression subClass;
    @Nonnull
    private final OWLClassExpression superClass;

    public OWLSubClassOfAxiomImpl(@Nonnull OWLClassExpression subClass, @Nonnull OWLClassExpression superClass, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subClass = (OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)subClass, (String)"subClass cannot be null");
        this.superClass = (OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)superClass, (String)"superClass cannot be null");
    }

    public OWLSubClassOfAxiom getAnnotatedAxiom(@Nonnull Set<OWLAnnotation> annotations) {
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, this.mergeAnnos(annotations));
    }

    public OWLSubClassOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, NO_ANNOTATIONS);
    }

    public OWLClassExpression getSubClass() {
        return this.subClass;
    }

    public OWLClassExpression getSuperClass() {
        return this.superClass;
    }

    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OWLSubClassOfAxiom)) {
            return false;
        }
        if (super.equals(obj)) {
            OWLSubClassOfAxiom other = (OWLSubClassOfAxiom)obj;
            return other.getSubClass().equals(this.subClass) && other.getSuperClass().equals(this.superClass);
        }
        return false;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLSubClassOfAxiom)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLSubClassOfAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSubClassOfAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSubClassOfAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.SUBCLASS_OF;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubClassOfAxiom other = (OWLSubClassOfAxiom)object;
        int diff = this.subClass.compareTo((Object)other.getSubClass());
        if (diff != 0) {
            return diff;
        }
        return this.superClass.compareTo((Object)other.getSuperClass());
    }
}

