/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ObjectPropertySimplifier;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectInverseOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyExpressionImpl;

public abstract class OWLObjectPropertyExpressionImpl
extends OWLPropertyExpressionImpl
implements OWLObjectPropertyExpression {
    private static final long serialVersionUID = 40000L;
    private OWLObjectPropertyExpression simplestForm;
    private OWLObjectPropertyExpression inverse;

    public boolean isObjectPropertyExpression() {
        return true;
    }

    public boolean isDataPropertyExpression() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLObjectPropertyExpression;
    }

    @Nonnull
    public OWLObjectPropertyExpression getSimplified() {
        if (this.simplestForm == null) {
            ObjectPropertySimplifier simplifier = new ObjectPropertySimplifier((OWLDataFactory)new OWLDataFactoryImpl());
            this.simplestForm = simplifier.getSimplified((OWLObjectPropertyExpression)this);
        }
        return (OWLObjectPropertyExpression)OWLAPIPreconditions.verifyNotNull((Object)this.simplestForm);
    }

    @Nonnull
    public OWLObjectPropertyExpression getInverseProperty() {
        if (this.inverse == null) {
            this.inverse = new OWLObjectInverseOfImpl(this);
        }
        return (OWLObjectPropertyExpression)OWLAPIPreconditions.verifyNotNull((Object)this.inverse);
    }

    public OWLObjectProperty getNamedProperty() {
        OWLObjectPropertyExpression simp = this.getSimplified();
        if (simp.isAnonymous()) {
            return ((OWLObjectInverseOf)simp).getInverse().asOWLObjectProperty();
        }
        return simp.asOWLObjectProperty();
    }
}

