/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLIndividualVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLIndividualImpl;

public class OWLNamedIndividualImpl
extends OWLIndividualImpl
implements OWLNamedIndividual {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI iri;

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    protected int index() {
        return 1005;
    }

    public OWLNamedIndividualImpl(@Nonnull IRI iri) {
        this.iri = (IRI)OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
    }

    public boolean isNamed() {
        return true;
    }

    public EntityType<?> getEntityType() {
        return EntityType.NAMED_INDIVIDUAL;
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public boolean isOWLNamedIndividual() {
        return true;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isAnonymous() {
        return false;
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        return this;
    }

    public OWLAnonymousIndividual asOWLAnonymousIndividual() {
        throw new OWLRuntimeException("Not an anonymous individual");
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OWLNamedIndividual)) {
            return false;
        }
        IRI otherIRI = ((OWLNamedIndividual)obj).getIRI();
        return otherIRI.equals((Object)this.iri);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLNamedIndividual other = (OWLNamedIndividual)object;
        return this.iri.compareTo((OWLObject)other.getIRI());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }

    public void accept(OWLIndividualVisitor visitor) {
        visitor.visit((OWLNamedIndividual)this);
    }

    public <O> O accept(OWLIndividualVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLNamedIndividual)this);
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public boolean isBuiltIn() {
        return false;
    }
}

