/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplNoCompression
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private final String literal;
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final String language;

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    protected int index() {
        return 4008;
    }

    public OWLLiteralImplNoCompression(@Nonnull String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = literal;
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null ? RDF_PLAIN_LITERAL : datatype;
        } else {
            if (datatype != null && !datatype.isRDFPlainLiteral()) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = RDF_PLAIN_LITERAL;
        }
        this.hashCode = this.getHashCode();
    }

    @Nonnull
    public String getLiteral() {
        return this.literal;
    }

    public boolean isRDFPlainLiteral() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    }

    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    public boolean isInteger() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_INTEGER.getIRI());
    }

    public int parseInteger() {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean isBoolean() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    public boolean parseBoolean() {
        if (this.literal.equals("0")) {
            return false;
        }
        if (this.literal.equals("1")) {
            return true;
        }
        if (this.literal.equals("true")) {
            return true;
        }
        if (this.literal.equals("false")) {
            return false;
        }
        return Boolean.parseBoolean(this.literal);
    }

    public boolean isDouble() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    public double parseDouble() {
        return Double.parseDouble(this.literal);
    }

    public boolean isFloat() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_FLOAT.getIRI());
    }

    public float parseFloat() {
        if ("inf".equalsIgnoreCase(this.literal)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(this.literal)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(this.literal);
    }

    @Nonnull
    public String getLang() {
        return this.language;
    }

    public boolean hasLang(@Nullable String lang) {
        if (lang == null) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    @Nonnull
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode *= 37;
        try {
            hashCode = this.isInteger() ? (hashCode += this.parseInteger() * 65536) : (this.isDouble() ? (hashCode += (int)this.parseDouble() * 65536) : (this.isFloat() ? (hashCode += (int)this.parseFloat() * 65536) : (this.isBoolean() ? (hashCode += this.parseBoolean() ? 65536 : 0) : (hashCode += this.getLiteral().hashCode() * 65536))));
        }
        catch (NumberFormatException e) {
            hashCode += this.getLiteral().hashCode() * 65536;
        }
        if (this.hasLang()) {
            hashCode = hashCode * 37 + this.getLang().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLLiteral)) {
                return false;
            }
            OWLLiteral other = (OWLLiteral)obj;
            if (other instanceof OWLLiteralImplNoCompression) {
                return this.literal.equals(((OWLLiteralImplNoCompression)other).literal) && this.datatype.equals(other.getDatatype()) && this.language.equals(other.getLang());
            }
            return this.literal.equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.language.equals(other.getLang());
        }
        return false;
    }

    public void accept(@Nonnull OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(@Nonnull OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(@Nonnull OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.literal.compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.language.compareTo(other.getLang());
    }

    public void accept(@Nonnull OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

