/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplDouble
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    private final double literal;
    @Nonnull
    private final OWLDatatype datatype;
    private final int hashcode;

    @Override
    protected int index() {
        return 4008;
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    public OWLLiteralImplDouble(double literal, @Nonnull OWLDatatype datatype) {
        this.literal = literal;
        this.datatype = (OWLDatatype)OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        this.hashcode = this.getHashCode();
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode = hashCode * 37 + (int)(this.literal * 65536.0);
        return hashCode;
    }

    public String getLiteral() {
        return Double.toString(this.literal);
    }

    public boolean isRDFPlainLiteral() {
        return false;
    }

    public boolean hasLang() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public int parseInteger() {
        throw new NumberFormatException("this literal is not an integer but a double");
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean parseBoolean() {
        throw new NumberFormatException("this literal is not a boolean but a double");
    }

    public boolean isDouble() {
        return true;
    }

    public double parseDouble() {
        return this.literal;
    }

    public boolean isFloat() {
        return false;
    }

    public float parseFloat() {
        throw new NumberFormatException("this literal is not a float but a double");
    }

    @Nonnull
    public String getLang() {
        return "";
    }

    public boolean hasLang(String lang) {
        return false;
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj instanceof OWLLiteralImplDouble) {
                OWLLiteralImplDouble other = (OWLLiteralImplDouble)obj;
                return this.literal == other.literal && this.datatype.equals(other.getDatatype());
            }
            if (obj instanceof OWLLiteral) {
                return this.datatype.equals(((OWLLiteral)obj).getDatatype()) && this.getLiteral().equals(((OWLLiteral)obj).getLiteral());
            }
        }
        return false;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        int compareTo = this.datatype.compareTo((Object)other.getDatatype());
        if (compareTo != 0) {
            return compareTo;
        }
        return Double.compare(this.literal, other.parseDouble());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

