/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyExpressionImpl;

public class OWLDataPropertyImpl
extends OWLPropertyExpressionImpl
implements OWLDataProperty {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI iri;
    private final boolean builtin;

    @Override
    protected int index() {
        return 1004;
    }

    public OWLDataPropertyImpl(@Nonnull IRI iri) {
        this.iri = (IRI)OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        this.builtin = iri.equals((Object)OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    public boolean isTopEntity() {
        return this.isOWLTopDataProperty();
    }

    @Override
    public boolean isBottomEntity() {
        return this.isOWLBottomDataProperty();
    }

    public EntityType<?> getEntityType() {
        return EntityType.DATA_PROPERTY;
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public boolean isDataPropertyExpression() {
        return true;
    }

    public boolean isObjectPropertyExpression() {
        return false;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.builtin;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLDataProperty)) {
                return false;
            }
            IRI otherIRI = ((OWLDataProperty)obj).getIRI();
            return otherIRI.equals((Object)this.iri);
        }
        return false;
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public void accept(OWLPropertyExpressionVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLPropertyExpressionVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public boolean isAnonymous() {
        return false;
    }

    public OWLDataProperty asOWLDataProperty() {
        return this;
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not an OWLDatatype!");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an OWLIndividual!");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an OWLObjectProperty!");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return true;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public boolean isOWLTopObjectProperty() {
        return false;
    }

    public boolean isOWLBottomObjectProperty() {
        return false;
    }

    public boolean isOWLTopDataProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
    }

    public boolean isOWLBottomDataProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLDataProperty)object).getIRI());
    }
}

