/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.WeakIndexCache;
import uk.ac.manchester.cs.owl.owlapi.InternalsNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends InternalsNoCache {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final BuildableWeakIndexCache<OWLClass> classesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLObjectProperty> objectPropertiesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLDataProperty> dataPropertiesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLDatatype> datatypesByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLNamedIndividual> individualsByURI = this.buildCache();
    @Nonnull
    private final BuildableWeakIndexCache<OWLAnnotationProperty> annotationPropertiesByURI = this.buildCache();
    @Nonnull
    private final transient Interner<String> languageTagInterner = Interners.newWeakInterner();

    @Nonnull
    protected final <V extends OWLEntity> BuildableWeakIndexCache<V> buildCache() {
        return new BuildableWeakIndexCache();
    }

    public OWLDataFactoryInternalsImpl(boolean useCompression) {
        super(useCompression);
    }

    @Override
    @Nonnull
    public OWLClass getOWLClass(IRI iri) {
        return this.classesByURI.cache(iri, Buildable.OWLCLASS);
    }

    @Override
    public void purge() {
        this.classesByURI.clear();
        this.objectPropertiesByURI.clear();
        this.dataPropertiesByURI.clear();
        this.datatypesByURI.clear();
        this.individualsByURI.clear();
        this.annotationPropertiesByURI.clear();
    }

    @Override
    @Nonnull
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.objectPropertiesByURI.cache(iri, Buildable.OWLOBJECTPROPERTY);
    }

    @Override
    @Nonnull
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.dataPropertiesByURI.cache(iri, Buildable.OWLDATAPROPERTY);
    }

    @Override
    @Nonnull
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return this.individualsByURI.cache(iri, Buildable.OWLNAMEDINDIVIDUAL);
    }

    @Override
    @Nonnull
    public OWLDatatype getOWLDatatype(IRI iri) {
        return this.datatypesByURI.cache(iri, Buildable.OWLDATATYPE);
    }

    @Override
    @Nonnull
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return this.annotationPropertiesByURI.cache(iri, Buildable.OWLANNOTATIONPROPERTY);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        if (lang == null) {
            lang = "";
        }
        lang = (String)this.languageTagInterner.intern((Object)lang.trim().toLowerCase());
        return super.getOWLLiteral(literal, lang);
    }

    protected static enum Buildable {
        OWLCLASS{

            @Nonnull
            OWLClass build(@Nonnull IRI iri) {
                return new OWLClassImpl(iri);
            }
        }
        ,
        OWLOBJECTPROPERTY{

            @Nonnull
            OWLObjectProperty build(@Nonnull IRI iri) {
                return new OWLObjectPropertyImpl(iri);
            }
        }
        ,
        OWLDATAPROPERTY{

            @Nonnull
            OWLDataProperty build(@Nonnull IRI iri) {
                return new OWLDataPropertyImpl(iri);
            }
        }
        ,
        OWLNAMEDINDIVIDUAL{

            @Nonnull
            OWLNamedIndividual build(@Nonnull IRI iri) {
                return new OWLNamedIndividualImpl(iri);
            }
        }
        ,
        OWLDATATYPE{

            @Nonnull
            OWLDatatype build(@Nonnull IRI iri) {
                return new OWLDatatypeImpl(iri);
            }
        }
        ,
        OWLANNOTATIONPROPERTY{

            @Nonnull
            OWLAnnotationProperty build(@Nonnull IRI iri) {
                return new OWLAnnotationPropertyImpl(iri);
            }
        };


        @Nonnull
        abstract <K extends OWLEntity> K build(@Nonnull IRI var1);
    }

    protected class BuildableWeakIndexCache<V extends OWLEntity>
    extends WeakIndexCache<IRI, V> {
        private static final long serialVersionUID = 40000L;

        protected BuildableWeakIndexCache() {
        }

        @Nonnull
        public V cache(@Nonnull IRI s, @Nonnull Buildable v) {
            OWLEntity toReturn;
            WeakReference w = (WeakReference)this.prefixCache.get(s);
            if (w != null && (toReturn = (OWLEntity)w.get()) != null) {
                return (V)toReturn;
            }
            Object value = v.build(s);
            this.prefixCache.put(s, new WeakReference(value));
            return (V)value;
        }
    }
}

